/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.util.Collections;
import java.util.Set;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.backup.AbortBackupFactory;
import org.apache.geode.internal.cache.backup.BackupStep;

class AbortBackupStep
extends BackupStep {
    private final InternalDistributedMember member;
    private final InternalCache cache;
    private final Set<InternalDistributedMember> recipients;
    private final AbortBackupFactory abortBackupFactory;

    AbortBackupStep(DistributionManager dm, InternalDistributedMember member, InternalCache cache, Set<InternalDistributedMember> recipients, AbortBackupFactory abortBackupFactory) {
        super(dm);
        this.member = member;
        this.cache = cache;
        this.recipients = recipients;
        this.abortBackupFactory = abortBackupFactory;
    }

    @Override
    public void addToResults(InternalDistributedMember member, Set<PersistentID> persistentIds) {
        if (persistentIds != null) {
            this.getResults().put(member, persistentIds);
        }
    }

    @Override
    ReplyProcessor21 createReplyProcessor() {
        return this.abortBackupFactory.createReplyProcessor(this, this.getDistributionManager(), this.recipients);
    }

    @Override
    DistributionMessage createDistributionMessage(ReplyProcessor21 replyProcessor) {
        return this.abortBackupFactory.createRequest(this.member, this.recipients, replyProcessor.getProcessorId());
    }

    @Override
    void processLocally() {
        this.abortBackupFactory.createAbortBackup(this.cache).run();
        this.addToResults(this.member, Collections.emptySet());
    }
}

