/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed;

import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.LeaseExpiredException;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.locks.DLockService;

public abstract class DistributedLockService {
    public static DistributedLockService create(String serviceName, DistributedSystem ds) throws IllegalArgumentException {
        DLockService.validateServiceName(serviceName);
        return DLockService.create(serviceName, (InternalDistributedSystem)ds, true, false);
    }

    public static DistributedLockService getServiceNamed(String serviceName) {
        return DLockService.getServiceNamed(serviceName);
    }

    public static void destroy(String serviceName) throws IllegalArgumentException {
        DLockService.destroyServiceNamed(serviceName);
    }

    protected DistributedLockService() {
    }

    public abstract boolean lock(Object var1, long var2, long var4);

    @Deprecated
    public abstract boolean lockInterruptibly(Object var1, long var2, long var4) throws InterruptedException;

    public abstract void unlock(Object var1) throws LeaseExpiredException;

    public abstract boolean isHeldByCurrentThread(Object var1);

    @Deprecated
    public abstract boolean suspendLockingInterruptibly(long var1) throws InterruptedException;

    public abstract boolean suspendLocking(long var1);

    public abstract void resumeLocking();

    public abstract boolean isLockingSuspendedByCurrentThread();

    public abstract void freeResources(Object var1);

    public abstract void becomeLockGrantor();

    public static void becomeLockGrantor(String serviceName) throws IllegalArgumentException {
        DLockService.becomeLockGrantor(serviceName);
    }

    public abstract boolean isLockGrantor();

    public static boolean isLockGrantor(String serviceName) throws IllegalArgumentException {
        return DLockService.isLockGrantor(serviceName);
    }
}

