/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.cache.client.internal.ClientMetadataService;
import org.apache.geode.cache.client.internal.Endpoint;
import org.apache.geode.cache.client.internal.EndpointManager;
import org.apache.geode.cache.client.internal.InternalPool;
import org.apache.geode.cache.client.internal.PingOp;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class LiveServerPinger
extends EndpointManager.EndpointListenerAdapter {
    private static final Logger logger = LogService.getLogger();
    private static final long NANOS_PER_MS = 1000000L;
    private final ConcurrentMap<Endpoint, Future> taskFutures = new ConcurrentHashMap<Endpoint, Future>();
    protected final InternalPool pool;
    protected final long pingIntervalNanos;
    public static final int INITIAL_DELAY_MULTIPLIER_IN_MILLISECONDS = Integer.getInteger("gemfire.LiveServerPinger.INITIAL_DELAY_MULTIPLIER_IN_MILLISECONDS", 0);
    private final AtomicInteger initialDelayIndex = new AtomicInteger(0);

    public LiveServerPinger(InternalPool pool) {
        this.pool = pool;
        this.pingIntervalNanos = TimeUnit.MILLISECONDS.toNanos((pool.getPingInterval() + 1L) / 2L);
    }

    @Override
    public void endpointCrashed(Endpoint endpoint) {
        this.resetInitialDelay();
        this.cancelFuture(endpoint);
    }

    @Override
    public void endpointNoLongerInUse(Endpoint endpoint) {
        this.resetInitialDelay();
        this.cancelFuture(endpoint);
    }

    @Override
    public void endpointNowInUse(Endpoint endpoint) {
        block2: {
            try {
                long initDelay = this.calculateInitialDelay();
                ScheduledFuture<?> future = this.pool.getBackgroundProcessor().scheduleWithFixedDelay(new PingTask(endpoint), initDelay, this.pingIntervalNanos, TimeUnit.NANOSECONDS);
                this.taskFutures.put(endpoint, future);
            }
            catch (RejectedExecutionException e) {
                if (this.pool.getCancelCriterion().isCancelInProgress()) break block2;
                throw e;
            }
        }
    }

    private void cancelFuture(Endpoint endpoint) {
        Future future = (Future)this.taskFutures.remove(endpoint);
        if (future != null) {
            future.cancel(false);
        }
    }

    long calculateInitialDelay() {
        long initDelay = this.initialDelayIndex.getAndIncrement();
        initDelay = TimeUnit.MILLISECONDS.toNanos(initDelay * (long)INITIAL_DELAY_MULTIPLIER_IN_MILLISECONDS) + this.pingIntervalNanos;
        return initDelay;
    }

    void resetInitialDelay() {
        this.initialDelayIndex.set(0);
    }

    private class PingTask
    extends PoolImpl.PoolTask {
        private final Endpoint endpoint;

        PingTask(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public void run2() {
            if (this.endpoint.timeToPing(LiveServerPinger.this.pingIntervalNanos)) {
                try {
                    this.endpoint.updateLastExecute();
                    PingOp.execute(LiveServerPinger.this.pool, this.endpoint.getLocation(), this.endpoint.getMemberId());
                }
                catch (Exception e) {
                    GemFireCacheImpl cache;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Error occurred while pinging server: {} - {}", (Object)this.endpoint.getLocation(), (Object)e.getMessage());
                    }
                    if ((cache = GemFireCacheImpl.getInstance()) != null) {
                        ClientMetadataService cms = cache.getClientMetadataService();
                        cms.removeBucketServerLocation(this.endpoint.getLocation());
                    }
                    LiveServerPinger.this.pool.getEndpointManager().serverCrashed(this.endpoint);
                }
            }
        }
    }
}

