/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.ml.feature.idf;

import org.apache.flink.ml.param.IntParam;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.ParamValidators;

/**
 * Params for {@link IDF}.
 *
 * @param <T> The class type of this instance.
 */
public interface IDFParams<T> extends IDFModelParams<T> {
    Param<Integer> MIN_DOC_FREQ =
            new IntParam(
                    "minDocFreq",
                    "Minimum number of documents that a term should appear for filtering.",
                    0,
                    ParamValidators.gtEq(0));

    default int getMinDocFreq() {
        return get(MIN_DOC_FREQ);
    }

    default T setMinDocFreq(Integer value) {
        return set(MIN_DOC_FREQ, value);
    }
}
