/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.vectorindexer;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.DoubleSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;

public class VectorIndexerModelData {
    public static final TypeInformation<VectorIndexerModelData> TYPE_INFO = Types.POJO(VectorIndexerModelData.class, Collections.singletonMap("categoryMaps", Types.MAP((TypeInformation)Types.INT, (TypeInformation)Types.MAP((TypeInformation)Types.DOUBLE, (TypeInformation)Types.INT))));
    public Map<Integer, Map<Double, Integer>> categoryMaps;

    public VectorIndexerModelData(Map<Integer, Map<Double, Integer>> categoryMaps) {
        this.categoryMaps = categoryMaps;
    }

    public VectorIndexerModelData() {
    }

    public static DataStream<VectorIndexerModelData> getModelDataStream(Table modelData) {
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)modelData).getTableEnvironment();
        return tEnv.toDataStream(modelData).map((MapFunction & Serializable)x -> new VectorIndexerModelData((Map)x.getField(0)), TYPE_INFO);
    }

    public static class ModelDataDecoder
    extends SimpleStreamFormat<VectorIndexerModelData> {
        public StreamFormat.Reader<VectorIndexerModelData> createReader(Configuration configuration, final FSDataInputStream inputStream) {
            return new StreamFormat.Reader<VectorIndexerModelData>(){

                public VectorIndexerModelData read() throws IOException {
                    try {
                        DataInputViewStreamWrapper inputViewStreamWrapper = new DataInputViewStreamWrapper((InputStream)inputStream);
                        MapSerializer mapSerializer = new MapSerializer((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)new MapSerializer((TypeSerializer)DoubleSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE));
                        Map categoryMaps = mapSerializer.deserialize((DataInputView)inputViewStreamWrapper);
                        return new VectorIndexerModelData(categoryMaps);
                    }
                    catch (EOFException e) {
                        return null;
                    }
                }

                public void close() throws IOException {
                    inputStream.close();
                }
            };
        }

        public TypeInformation<VectorIndexerModelData> getProducedType() {
            return TYPE_INFO;
        }
    }

    public static class ModelDataEncoder
    implements Encoder<VectorIndexerModelData> {
        public void encode(VectorIndexerModelData modelData, OutputStream outputStream) throws IOException {
            DataOutputViewStreamWrapper outputViewStreamWrapper = new DataOutputViewStreamWrapper(outputStream);
            MapSerializer mapSerializer = new MapSerializer((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)new MapSerializer((TypeSerializer)DoubleSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE));
            mapSerializer.serialize(modelData.categoryMaps, (DataOutputView)outputViewStreamWrapper);
        }
    }
}

