/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.metrics;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.UniformReservoir;
import java.util.Objects;
import org.apache.flink.dropwizard.metrics.DropwizardHistogramWrapper;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.statefun.flink.core.metrics.FunctionTypeMetrics;
import org.apache.flink.statefun.flink.core.metrics.NonNegativeCounter;
import org.apache.flink.statefun.sdk.metrics.Metrics;

final class FlinkFunctionTypeMetrics
implements FunctionTypeMetrics {
    private final Counter incoming;
    private final Counter outgoingLocalMessage;
    private final Counter outgoingRemoteMessage;
    private final Counter outgoingEgress;
    private final Counter blockedAddress;
    private final Counter inflightAsyncOps;
    private final Counter backlogMessage;
    private final Counter remoteInvocationFailures;
    private final org.apache.flink.metrics.Histogram remoteInvocationLatency;
    private final Metrics functionTypeScopedMetrics;

    FlinkFunctionTypeMetrics(MetricGroup typeGroup, Metrics functionTypeScopedMetrics) {
        this.incoming = FlinkFunctionTypeMetrics.metered(typeGroup, "in");
        this.outgoingLocalMessage = FlinkFunctionTypeMetrics.metered(typeGroup, "outLocal");
        this.outgoingRemoteMessage = FlinkFunctionTypeMetrics.metered(typeGroup, "outRemote");
        this.outgoingEgress = FlinkFunctionTypeMetrics.metered(typeGroup, "outEgress");
        this.blockedAddress = typeGroup.counter("numBlockedAddress");
        this.inflightAsyncOps = typeGroup.counter("inflightAsyncOps");
        this.backlogMessage = typeGroup.counter("numBacklog", (Counter)new NonNegativeCounter());
        this.remoteInvocationFailures = FlinkFunctionTypeMetrics.metered(typeGroup, "remoteInvocationFailures");
        this.remoteInvocationLatency = typeGroup.histogram("remoteInvocationLatency", (org.apache.flink.metrics.Histogram)FlinkFunctionTypeMetrics.histogram());
        this.functionTypeScopedMetrics = Objects.requireNonNull(functionTypeScopedMetrics);
    }

    @Override
    public void incomingMessage() {
        this.incoming.inc();
    }

    @Override
    public void outgoingLocalMessage() {
        this.outgoingLocalMessage.inc();
    }

    @Override
    public void outgoingRemoteMessage() {
        this.outgoingRemoteMessage.inc();
    }

    @Override
    public void outgoingEgressMessage() {
        this.outgoingEgress.inc();
    }

    @Override
    public void blockedAddress() {
        this.blockedAddress.inc();
    }

    @Override
    public void unblockedAddress() {
        this.blockedAddress.dec();
    }

    @Override
    public void asyncOperationRegistered() {
        this.inflightAsyncOps.inc();
    }

    @Override
    public void asyncOperationCompleted() {
        this.inflightAsyncOps.dec();
    }

    @Override
    public void appendBacklogMessages(int count) {
        this.backlogMessage.inc((long)count);
    }

    @Override
    public void consumeBacklogMessages(int count) {
        this.backlogMessage.dec((long)count);
    }

    @Override
    public Metrics functionTypeScopedMetrics() {
        return this.functionTypeScopedMetrics;
    }

    @Override
    public void remoteInvocationFailures() {
        this.remoteInvocationFailures.inc();
    }

    @Override
    public void remoteInvocationLatency(long elapsed) {
        this.remoteInvocationLatency.update(elapsed);
    }

    private static SimpleCounter metered(MetricGroup metrics, String name) {
        SimpleCounter counter = (SimpleCounter)metrics.counter(name, (Counter)new SimpleCounter());
        metrics.meter(name + "Rate", (Meter)new MeterView((Counter)counter, 60));
        return counter;
    }

    private static DropwizardHistogramWrapper histogram() {
        Histogram dropwizardHistogram = new Histogram((Reservoir)new UniformReservoir());
        return new DropwizardHistogramWrapper(dropwizardHistogram);
    }
}

