/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.functions;

import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.KeyedStateFunction;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.statefun.flink.core.functions.Reductions;
import org.apache.flink.statefun.flink.core.message.Message;

final class AsyncOperationFailureNotifier
implements KeyedStateFunction<String, MapState<Long, Message>> {
    private final Reductions reductions;
    private boolean enqueued;

    static void fireExpiredAsyncOperations(MapStateDescriptor<Long, Message> asyncOperationStateDescriptor, Reductions reductions, KeyedStateBackend<String> keyedStateBackend) throws Exception {
        AsyncOperationFailureNotifier asyncOperationFailureNotifier = new AsyncOperationFailureNotifier(reductions);
        keyedStateBackend.applyToAllKeys((Object)VoidNamespace.get(), (TypeSerializer)VoidNamespaceSerializer.INSTANCE, asyncOperationStateDescriptor, (KeyedStateFunction)asyncOperationFailureNotifier);
        if (asyncOperationFailureNotifier.enqueued()) {
            reductions.processEnvelopes();
        }
    }

    private AsyncOperationFailureNotifier(Reductions reductions) {
        this.reductions = Objects.requireNonNull(reductions);
    }

    public void process(String key, MapState<Long, Message> state) throws Exception {
        for (Map.Entry entry : state.entries()) {
            Long futureId = (Long)entry.getKey();
            Message metadataMessage = (Message)entry.getValue();
            this.reductions.enqueueAsyncOperationAfterRestore(futureId, metadataMessage);
            this.enqueued = true;
        }
    }

    private boolean enqueued() {
        return this.enqueued;
    }
}

