/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.message;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.statefun.flink.core.generated.Envelope;
import org.apache.flink.statefun.flink.core.generated.EnvelopeAddress;
import org.apache.flink.statefun.flink.core.message.Message;
import org.apache.flink.statefun.flink.core.message.MessageFactory;
import org.apache.flink.statefun.sdk.Address;
import org.apache.flink.statefun.sdk.FunctionType;

final class ProtobufMessage
implements Message {
    private final Envelope envelope;
    private Address source;
    private Address target;
    private Object payload;

    ProtobufMessage(Envelope envelope) {
        this.envelope = Objects.requireNonNull(envelope);
    }

    @Override
    @Nullable
    public Address source() {
        if (this.source != null) {
            return this.source;
        }
        this.source = ProtobufMessage.protobufAddressToSdkAddress(this.envelope.getSource());
        if (this.source == null) {
            return null;
        }
        return this.source;
    }

    @Override
    public Address target() {
        if (this.target != null) {
            return this.target;
        }
        this.target = ProtobufMessage.protobufAddressToSdkAddress(this.envelope.getTarget());
        if (this.target == null) {
            throw new IllegalStateException("A mandatory target address is missing");
        }
        return this.target;
    }

    @Override
    public Object payload(MessageFactory factory, ClassLoader targetClassLoader) {
        if (this.payload == null) {
            this.payload = factory.deserializeUserMessagePayload(targetClassLoader, this.envelope.getPayload());
        } else if (!ProtobufMessage.sameClassLoader(targetClassLoader, this.payload)) {
            this.payload = factory.copyUserMessagePayload(targetClassLoader, this.payload);
        }
        return this.payload;
    }

    @Override
    public OptionalLong isBarrierMessage() {
        if (!this.envelope.hasCheckpoint()) {
            return OptionalLong.empty();
        }
        long checkpointId = this.envelope.getCheckpoint().getCheckpointId();
        return OptionalLong.of(checkpointId);
    }

    @Override
    public Optional<String> cancellationToken() {
        String token = this.envelope.getCancellationToken();
        if (token.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(token);
    }

    @Override
    public Message copy(MessageFactory unused) {
        return new ProtobufMessage(this.envelope);
    }

    @Override
    public void writeTo(MessageFactory factory, DataOutputView target) throws IOException {
        Objects.requireNonNull(target);
        factory.serializeEnvelope(this.envelope, target);
    }

    private static boolean sameClassLoader(ClassLoader targetClassLoader, Object payload) {
        return payload.getClass().getClassLoader() == targetClassLoader;
    }

    @Nullable
    private static Address protobufAddressToSdkAddress(EnvelopeAddress address) {
        if (address == null || address.getId().isEmpty() && address.getNamespace().isEmpty() && address.getType().isEmpty()) {
            return null;
        }
        FunctionType functionType = new FunctionType(address.getNamespace(), address.getType());
        return new Address(functionType, address.getId());
    }
}

