/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.benchmark.datagenerator.common;

import java.util.Arrays;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.benchmark.datagenerator.common.InputTableGenerator;
import org.apache.flink.ml.benchmark.datagenerator.common.RowGenerator;
import org.apache.flink.ml.benchmark.datagenerator.param.HasNumDistinctValues;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class RandomStringGenerator
extends InputTableGenerator<RandomStringGenerator>
implements HasNumDistinctValues<RandomStringGenerator> {
    @Override
    protected RowGenerator[] getRowGenerators() {
        final String[][] colNames = this.getColNames();
        Preconditions.checkState((colNames.length == 1 ? 1 : 0) != 0);
        final int numOutputCols = colNames[0].length;
        final int numDistinctValues = this.getNumDistinctValues();
        return new RowGenerator[]{new RowGenerator(this.getNumValues(), this.getSeed()){

            @Override
            public Row getRow() {
                Row r = new Row(numOutputCols);
                for (int i = 0; i < numOutputCols; ++i) {
                    r.setField(i, (Object)Integer.toString(this.random.nextInt(numDistinctValues)));
                }
                return r;
            }

            @Override
            protected RowTypeInfo getRowTypeInfo() {
                Object[] outputTypes = new TypeInformation[colNames[0].length];
                Arrays.fill(outputTypes, Types.STRING);
                return new RowTypeInfo((TypeInformation[])outputTypes, colNames[0]);
            }
        }};
    }
}

