/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.connector.prometheus.sink.aws;

import org.junit.jupiter.api.Test;

import static org.apache.flink.util.InstantiationUtil.isSerializable;
import static org.junit.jupiter.api.Assertions.assertTrue;

public class AmazonManagedPrometheusWriteRequestSignerSerializationTest {

    @Test
    void shouldBeActuallySerializable() {
        AmazonManagedPrometheusWriteRequestSigner signer =
                new AmazonManagedPrometheusWriteRequestSigner(
                        "http://example.com/endpoint", "us-east-1");
        assertTrue(isSerializable(signer), "The request signer should be serializable");
    }
}
