/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.binary.BinaryStringDataUtil;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class SplitFunction
extends BuiltInScalarFunction {
    public SplitFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.SPLIT, context);
    }

    @Nullable
    public ArrayData eval(@Nullable StringData string, @Nullable StringData delimiter) {
        try {
            if (string == null || delimiter == null) {
                return null;
            }
            if (delimiter.toString().isEmpty()) {
                String str = string.toString();
                ArrayList<StringData> res = new ArrayList<StringData>();
                for (int i = 0; i < str.length(); ++i) {
                    res.add(StringData.fromString((String)String.valueOf(str.charAt(i))));
                }
                return new GenericArrayData(res.toArray());
            }
            Object[] binaryStringData = BinaryStringDataUtil.splitByWholeSeparatorPreserveAllTokens((BinaryStringData)string, (BinaryStringData)delimiter);
            return new GenericArrayData(binaryStringData);
        }
        catch (Throwable t) {
            throw new FlinkRuntimeException(t);
        }
    }
}

