/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.source.reader.fetcher;

import java.io.IOException;
import java.util.Collection;
import java.util.function.Consumer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.fetcher.SplitFetcherTask;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.connector.base.source.reader.synchronization.FutureCompletingBlockingQueue;

@Internal
class FetchTask<E, SplitT extends SourceSplit>
implements SplitFetcherTask {
    private final SplitReader<E, SplitT> splitReader;
    private final FutureCompletingBlockingQueue<RecordsWithSplitIds<E>> elementsQueue;
    private final Consumer<Collection<String>> splitFinishedCallback;
    private final int fetcherIndex;
    private volatile RecordsWithSplitIds<E> lastRecords;
    private volatile boolean wakeup;

    FetchTask(SplitReader<E, SplitT> splitReader, FutureCompletingBlockingQueue<RecordsWithSplitIds<E>> elementsQueue, Consumer<Collection<String>> splitFinishedCallback, int fetcherIndex) {
        this.splitReader = splitReader;
        this.elementsQueue = elementsQueue;
        this.splitFinishedCallback = splitFinishedCallback;
        this.lastRecords = null;
        this.fetcherIndex = fetcherIndex;
        this.wakeup = false;
    }

    @Override
    public boolean run() throws IOException {
        try {
            if (!this.isWakenUp() && this.lastRecords == null) {
                this.lastRecords = this.splitReader.fetch();
            }
            if (!this.isWakenUp() && this.elementsQueue.put(this.fetcherIndex, this.lastRecords)) {
                if (!this.lastRecords.finishedSplits().isEmpty()) {
                    this.splitFinishedCallback.accept(this.lastRecords.finishedSplits());
                }
                this.lastRecords = null;
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Source fetch execution was interrupted", e);
        }
        finally {
            if (this.isWakenUp()) {
                this.wakeup = false;
            }
        }
        return true;
    }

    @Override
    public void wakeUp() {
        this.wakeup = true;
        if (this.lastRecords == null) {
            this.splitReader.wakeUp();
        } else {
            this.elementsQueue.wakeUpPuttingThread(this.fetcherIndex);
        }
    }

    private boolean isWakenUp() {
        return this.wakeup;
    }

    public String toString() {
        return "FetchTask";
    }
}

