/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize.program;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkRuleSetProgram;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.utils.Logging;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001\u0002\b\u0010\u0001\u0001BQ!\u0010\u0001\u0005\u0002yBq\u0001\u0011\u0001C\u0002\u0013%\u0011\t\u0003\u0004V\u0001\u0001\u0006IA\u0011\u0005\b-\u0002\u0011\r\u0011\"\u0003X\u0011\u0019Y\u0006\u0001)A\u00051\")!\u0003\u0001C\u00019\")\u0011\u000e\u0001C\u0001U\")\u0001\u000f\u0001C\u0001c\")q\u000f\u0001C\u0001q\")a\u0010\u0001C\u0001\u007f\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003/\u0001A\u0011AA\r\u0005M1E.\u001b8l\u0007\"\f\u0017N\\3e!J|wM]1n\u0015\t\u0001\u0012#A\u0004qe><'/Y7\u000b\u0005I\u0019\u0012\u0001C8qi&l\u0017N_3\u000b\u0005Q)\u0012\u0001\u00029mC:T!AF\f\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0001$G\u0001\u0006i\u0006\u0014G.\u001a\u0006\u00035m\tQA\u001a7j].T!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sO\u000e\u0001QCA\u0011/'\u0011\u0001!\u0005K\u001c\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g!\rI#\u0006L\u0007\u0002\u001f%\u00111f\u0004\u0002\u0015\r2Lgn[(qi&l\u0017N_3Qe><'/Y7\u0011\u00055rC\u0002\u0001\u0003\u0006_\u0001\u0011\r\u0001\r\u0002\u0003\u001f\u000e\u000b\"!\r\u001b\u0011\u0005\r\u0012\u0014BA\u001a%\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!K\u001b\n\u0005Yz!\u0001\u0006$mS:\\w\n\u001d;j[&TXmQ8oi\u0016DH\u000f\u0005\u00029w5\t\u0011H\u0003\u0002;+\u0005)Q\u000f^5mg&\u0011A(\u000f\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tq\bE\u0002*\u00011\nA\u0002\u001d:pOJ\fWNT1nKN,\u0012A\u0011\t\u0004\u0007\"SU\"\u0001#\u000b\u0005\u00153\u0015\u0001B;uS2T\u0011aR\u0001\u0005U\u00064\u0018-\u0003\u0002J\t\nI\u0011I\u001d:bs2K7\u000f\u001e\t\u0003\u0017Js!\u0001\u0014)\u0011\u00055#S\"\u0001(\u000b\u0005={\u0012A\u0002\u001fs_>$h(\u0003\u0002RI\u00051\u0001K]3eK\u001aL!a\u0015+\u0003\rM#(/\u001b8h\u0015\t\tF%A\u0007qe><'/Y7OC6,7\u000fI\u0001\u000baJ|wM]1n\u001b\u0006\u0004X#\u0001-\u0011\t\rK&\nK\u0005\u00035\u0012\u0013q\u0001S1tQ6\u000b\u0007/A\u0006qe><'/Y7NCB\u0004CcA/fOB\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\u0004e\u0016d'B\u00012\u001c\u0003\u001d\u0019\u0017\r\\2ji\u0016L!\u0001Z0\u0003\u000fI+GNT8eK\")aM\u0002a\u0001;\u0006!!o\\8u\u0011\u0015Ag\u00011\u0001-\u0003\u001d\u0019wN\u001c;fqR\f1aZ3u)\tYg\u000eE\u0002$Y\"J!!\u001c\u0013\u0003\r=\u0003H/[8o\u0011\u0015yw\u00011\u0001K\u0003\u0011q\u0017-\\3\u0002-\u001d,GO\u00127j].\u0014V\u000f\\3TKR\u0004&o\\4sC6$\"A\u001d<\u0011\u0007\rb7\u000fE\u0002*i2J!!^\b\u0003'\u0019c\u0017N\\6Sk2,7+\u001a;Qe><'/Y7\t\u000b=D\u0001\u0019\u0001&\u0002\u000f\u0005$G\rT1tiR\u0019\u0011\u0010`?\u0011\u0005\rR\u0018BA>%\u0005\u001d\u0011un\u001c7fC:DQa\\\u0005A\u0002)CQ\u0001E\u0005A\u0002!\n\u0001\"\u00193e\r&\u00148\u000f\u001e\u000b\u0006s\u0006\u0005\u00111\u0001\u0005\u0006_*\u0001\rA\u0013\u0005\u0006!)\u0001\r\u0001K\u0001\nC\u0012$')\u001a4pe\u0016$r!_A\u0005\u0003\u001b\ty\u0001\u0003\u0004\u0002\f-\u0001\rAS\u0001\r]\u0006lWm\u00144CK\u001a|'/\u001a\u0005\u0006_.\u0001\rA\u0013\u0005\u0006!-\u0001\r\u0001K\u0001\u0007e\u0016lwN^3\u0015\u0007-\f)\u0002C\u0003p\u0019\u0001\u0007!*A\bhKR\u0004&o\\4sC6t\u0015-\\3t+\t\tY\u0002\u0005\u0003D\u0003;Q\u0015bAA\u0010\t\n!A*[:u\u0001")
public class FlinkChainedProgram<OC extends FlinkOptimizeContext>
implements FlinkOptimizeProgram<OC>,
Logging {
    private final ArrayList<String> programNames;
    private final HashMap<String, FlinkOptimizeProgram<OC>> programMap;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        FlinkChainedProgram flinkChainedProgram = this;
        synchronized (flinkChainedProgram) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        if (!this.bitmap$trans$0) {
            return this.LOG$lzycompute();
        }
        return this.LOG;
    }

    private ArrayList<String> programNames() {
        return this.programNames;
    }

    private HashMap<String, FlinkOptimizeProgram<OC>> programMap() {
        return this.programMap;
    }

    @Override
    public RelNode optimize(RelNode root, OC context) {
        return (RelNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.programNames()).foldLeft((Object)root, (Function2 & Serializable & scala.Serializable)(input, name) -> {
            RelNode result;
            block0: {
                FlinkOptimizeProgram program = (FlinkOptimizeProgram)this.get((String)name).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new TableException("This should not happen.");
                });
                long start = System.currentTimeMillis();
                result = program.optimize((RelNode)input, context);
                long end = System.currentTimeMillis();
                if (!this.LOG().isDebugEnabled()) break block0;
                this.LOG().debug(new StringBuilder(38).append("optimize ").append((String)name).append(" cost ").append(end - start).append(" ms.\n").append("optimize result: \n").append(FlinkRelOptUtil$.MODULE$.toString(result, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7(), FlinkRelOptUtil$.MODULE$.toString$default$8())).toString());
            }
            return result;
        });
    }

    public Option<FlinkOptimizeProgram<OC>> get(String name) {
        return Option$.MODULE$.apply(this.programMap().get(name));
    }

    public Option<FlinkRuleSetProgram<OC>> getFlinkRuleSetProgram(String name) {
        Object object = this.get(name).getOrElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
        if (object instanceof FlinkRuleSetProgram) {
            FlinkRuleSetProgram flinkRuleSetProgram = (FlinkRuleSetProgram)object;
            return new Some((Object)flinkRuleSetProgram);
        }
        return None$.MODULE$;
    }

    public boolean addLast(String name, FlinkOptimizeProgram<OC> program) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(program);
        if (this.programNames().contains(name)) {
            return false;
        }
        this.programNames().add(name);
        this.programMap().put(name, program);
        return true;
    }

    public boolean addFirst(String name, FlinkOptimizeProgram<OC> program) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(program);
        if (this.programNames().contains(name)) {
            return false;
        }
        this.programNames().add(0, name);
        this.programMap().put(name, program);
        return true;
    }

    public boolean addBefore(String nameOfBefore, String name, FlinkOptimizeProgram<OC> program) {
        Preconditions.checkNotNull((Object)nameOfBefore);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(program);
        if (this.programNames().contains(name) || !this.programNames().contains(nameOfBefore)) {
            return false;
        }
        if (this.programNames().isEmpty()) {
            return this.addLast(name, program);
        }
        int index = this.programNames().indexOf(nameOfBefore);
        this.programNames().add(index, name);
        this.programMap().put(name, program);
        return true;
    }

    public Option<FlinkOptimizeProgram<OC>> remove(String name) {
        this.programNames().remove(name);
        return Option$.MODULE$.apply(this.programMap().remove(name));
    }

    public List<String> getProgramNames() {
        return new ArrayList<String>(this.programNames());
    }

    public FlinkChainedProgram() {
        Logging.$init$(this);
        this.programNames = new ArrayList();
        this.programMap = new HashMap();
    }
}

