/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.runtime.asyncprocessing.operators.AsyncKeyedProcessOperator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.KeyedProcessOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.EqualiserCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.StateMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.plan.utils.RankUtil;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.bundle.KeyedMapBundleOperator;
import org.apache.flink.table.runtime.operators.bundle.MapBundleFunction;
import org.apache.flink.table.runtime.operators.bundle.trigger.BundleTrigger;
import org.apache.flink.table.runtime.operators.bundle.trigger.CountBundleTrigger;
import org.apache.flink.table.runtime.operators.deduplicate.ProcTimeDeduplicateKeepFirstRowFunction;
import org.apache.flink.table.runtime.operators.deduplicate.ProcTimeDeduplicateKeepLastRowFunction;
import org.apache.flink.table.runtime.operators.deduplicate.ProcTimeMiniBatchDeduplicateKeepFirstRowFunction;
import org.apache.flink.table.runtime.operators.deduplicate.ProcTimeMiniBatchDeduplicateKeepLastRowFunction;
import org.apache.flink.table.runtime.operators.deduplicate.RowTimeDeduplicateFunction;
import org.apache.flink.table.runtime.operators.deduplicate.RowTimeDeduplicateKeepFirstRowFunction;
import org.apache.flink.table.runtime.operators.deduplicate.RowTimeMiniBatchDeduplicateFunction;
import org.apache.flink.table.runtime.operators.deduplicate.RowTimeMiniBatchLatestChangeDeduplicateFunction;
import org.apache.flink.table.runtime.operators.deduplicate.asyncprocessing.AsyncStateRowTimeDeduplicateFunction;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@ExecNodeMetadata(name="stream-exec-deduplicate", version=1, consumedOptions={"table.exec.mini-batch.enabled", "table.exec.mini-batch.size", "table.exec.deduplicate.insert-update-after-sensitive-enabled", "table.exec.deduplicate.mini-batch.compact-changes-enabled"}, producedTransformations={"deduplicate"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
public class StreamExecDeduplicate
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    public static final String DEDUPLICATE_TRANSFORMATION = "deduplicate";
    public static final String FIELD_NAME_UNIQUE_KEYS = "uniqueKeys";
    public static final String FIELD_NAME_IS_ROWTIME = "isRowtime";
    public static final String FIELD_NAME_KEEP_LAST_ROW = "keepLastRow";
    public static final String FIELD_NAME_GENERATE_UPDATE_BEFORE = "generateUpdateBefore";
    public static final String STATE_NAME = "deduplicateState";
    public static final String FIELD_NAME_OUTPUT_INSERT_ONLY = "outputInsertOnly";
    @JsonProperty(value="uniqueKeys")
    private final int[] uniqueKeys;
    @JsonProperty(value="isRowtime")
    private final boolean isRowtime;
    @JsonProperty(value="keepLastRow")
    private final boolean keepLastRow;
    @JsonProperty(value="generateUpdateBefore")
    private final boolean generateUpdateBefore;
    @Nullable
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final List<StateMetadata> stateMetadataList;
    @Nullable
    @JsonProperty(value="outputInsertOnly")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Boolean outputInsertOnly;

    public StreamExecDeduplicate(ReadableConfig tableConfig, int[] uniqueKeys, boolean isRowtime, boolean keepLastRow, boolean outputInsertOnly, boolean generateUpdateBefore, InputProperty inputProperty, RowType outputType, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecDeduplicate.class), ExecNodeContext.newPersistedConfig(StreamExecDeduplicate.class, tableConfig), uniqueKeys, isRowtime, keepLastRow, outputInsertOnly, generateUpdateBefore, StateMetadata.getOneInputOperatorDefaultMeta(tableConfig, STATE_NAME), Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecDeduplicate(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="uniqueKeys") int[] uniqueKeys, @JsonProperty(value="isRowtime") boolean isRowtime, @JsonProperty(value="keepLastRow") boolean keepLastRow, @Nullable @JsonProperty(value="outputInsertOnly") Boolean outputInsertOnly, @JsonProperty(value="generateUpdateBefore") boolean generateUpdateBefore, @Nullable @JsonProperty(value="state") List<StateMetadata> stateMetadataList, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
        this.uniqueKeys = (int[])Preconditions.checkNotNull((Object)uniqueKeys);
        this.isRowtime = isRowtime;
        this.keepLastRow = keepLastRow;
        this.outputInsertOnly = outputInsertOnly == null ? false : outputInsertOnly;
        this.generateUpdateBefore = generateUpdateBefore;
        this.stateMetadataList = stateMetadataList;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        InternalTypeInfo rowTypeInfo = (InternalTypeInfo)inputTransform.getOutputType();
        TypeSerializer rowSerializer = rowTypeInfo.createSerializer(planner.getExecEnv().getConfig().getSerializerConfig());
        long stateRetentionTime = StateMetadata.getStateTtlForOneInputOperator(config, this.stateMetadataList);
        OneInputStreamOperator<RowData, RowData> operator = this.isRowtime ? new RowtimeDeduplicateOperatorTranslator(config, (InternalTypeInfo<RowData>)rowTypeInfo, (TypeSerializer<RowData>)rowSerializer, inputRowType, this.keepLastRow, this.outputInsertOnly, this.generateUpdateBefore, stateRetentionTime).createDeduplicateOperator() : new ProcTimeDeduplicateOperatorTranslator(config, planner.getFlinkContext().getClassLoader(), (InternalTypeInfo<RowData>)rowTypeInfo, (TypeSerializer<RowData>)rowSerializer, inputRowType, this.keepLastRow, this.outputInsertOnly, this.generateUpdateBefore, stateRetentionTime).createDeduplicateOperator();
        OneInputTransformation transform = ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(DEDUPLICATE_TRANSFORMATION, config), operator, rowTypeInfo, inputTransform.getParallelism(), false);
        RowDataKeySelector selector = KeySelectorUtil.getRowDataSelector(planner.getFlinkContext().getClassLoader(), this.uniqueKeys, (InternalTypeInfo<RowData>)rowTypeInfo);
        transform.setStateKeySelector((KeySelector)selector);
        transform.setStateKeyType((TypeInformation)selector.getProducedType());
        return transform;
    }

    private static class ProcTimeDeduplicateOperatorTranslator
    extends DeduplicateOperatorTranslator {
        private final GeneratedRecordEqualiser generatedEqualiser;

        protected ProcTimeDeduplicateOperatorTranslator(ReadableConfig config, ClassLoader classLoader, InternalTypeInfo<RowData> rowTypeInfo, TypeSerializer<RowData> typeSerializer, RowType inputRowType, boolean keepLastRow, boolean outputInsertOnly, boolean generateUpdateBefore, long stateRetentionTime) {
            super(config, rowTypeInfo, typeSerializer, keepLastRow, outputInsertOnly, generateUpdateBefore, stateRetentionTime);
            this.generatedEqualiser = new EqualiserCodeGenerator((LogicalType)inputRowType, classLoader).generateRecordEqualiser("DeduplicateRowEqualiser");
        }

        @Override
        OneInputStreamOperator<RowData, RowData> createDeduplicateOperator() {
            if (this.isMiniBatchEnabled()) {
                Preconditions.checkState((!RankUtil.outputInsertOnlyInDeduplicate(this.config, this.keepLastRow) ? 1 : 0) != 0);
                Preconditions.checkState((!this.outputInsertOnly ? 1 : 0) != 0);
                CountBundleTrigger trigger = new CountBundleTrigger(this.getMiniBatchSize());
                if (this.keepLastRow) {
                    ProcTimeMiniBatchDeduplicateKeepLastRowFunction processFunction = new ProcTimeMiniBatchDeduplicateKeepLastRowFunction(this.rowTypeInfo, this.typeSerializer, this.stateRetentionTime, this.generateUpdateBefore, this.generateInsert(), true, this.generatedEqualiser, null);
                    return new KeyedMapBundleOperator((MapBundleFunction)processFunction, (BundleTrigger)trigger);
                }
                ProcTimeMiniBatchDeduplicateKeepFirstRowFunction processFunction = new ProcTimeMiniBatchDeduplicateKeepFirstRowFunction(this.typeSerializer, this.stateRetentionTime);
                return new KeyedMapBundleOperator((MapBundleFunction)processFunction, (BundleTrigger)trigger);
            }
            if (this.keepLastRow) {
                Preconditions.checkState((!RankUtil.outputInsertOnlyInDeduplicate(this.config, this.keepLastRow) ? 1 : 0) != 0);
                ProcTimeDeduplicateKeepLastRowFunction processFunction = new ProcTimeDeduplicateKeepLastRowFunction(this.rowTypeInfo, this.stateRetentionTime, this.generateUpdateBefore, this.generateInsert(), true, this.generatedEqualiser, null);
                return new KeyedProcessOperator((KeyedProcessFunction)processFunction);
            }
            Preconditions.checkState((boolean)RankUtil.outputInsertOnlyInDeduplicate(this.config, this.keepLastRow));
            ProcTimeDeduplicateKeepFirstRowFunction processFunction = new ProcTimeDeduplicateKeepFirstRowFunction(this.stateRetentionTime);
            return new KeyedProcessOperator((KeyedProcessFunction)processFunction);
        }
    }

    private static class RowtimeDeduplicateOperatorTranslator
    extends DeduplicateOperatorTranslator {
        private final RowType inputRowType;

        protected RowtimeDeduplicateOperatorTranslator(ReadableConfig config, InternalTypeInfo<RowData> rowTypeInfo, TypeSerializer<RowData> typeSerializer, RowType inputRowType, boolean keepLastRow, boolean outputInsertOnly, boolean generateUpdateBefore, long stateRetentionTime) {
            super(config, rowTypeInfo, typeSerializer, keepLastRow, outputInsertOnly, generateUpdateBefore, stateRetentionTime);
            this.inputRowType = inputRowType;
        }

        @Override
        OneInputStreamOperator<RowData, RowData> createDeduplicateOperator() {
            int rowtimeIndex = -1;
            for (int i = 0; i < this.inputRowType.getFieldCount(); ++i) {
                if (!TypeCheckUtils.isRowTime((LogicalType)this.inputRowType.getTypeAt(i))) continue;
                rowtimeIndex = i;
                break;
            }
            Preconditions.checkArgument((rowtimeIndex >= 0 ? 1 : 0) != 0);
            if (this.isMiniBatchEnabled()) {
                Preconditions.checkState((!RankUtil.outputInsertOnlyInDeduplicate(this.config, this.keepLastRow) ? 1 : 0) != 0);
                Preconditions.checkState((!this.outputInsertOnly ? 1 : 0) != 0);
                CountBundleTrigger trigger = new CountBundleTrigger(this.getMiniBatchSize());
                if (this.isCompactChanges()) {
                    return new KeyedMapBundleOperator((MapBundleFunction)new RowTimeMiniBatchLatestChangeDeduplicateFunction(this.rowTypeInfo, this.typeSerializer, this.stateRetentionTime, rowtimeIndex, this.generateUpdateBefore, this.generateInsert(), this.keepLastRow), (BundleTrigger)trigger);
                }
                return new KeyedMapBundleOperator((MapBundleFunction)new RowTimeMiniBatchDeduplicateFunction(this.rowTypeInfo, this.typeSerializer, this.stateRetentionTime, rowtimeIndex, this.generateUpdateBefore, this.generateInsert(), this.keepLastRow), (BundleTrigger)trigger);
            }
            if (this.isAsyncStateEnabled()) {
                if (!this.keepLastRow && this.outputInsertOnly) {
                    Preconditions.checkState((boolean)RankUtil.outputInsertOnlyInDeduplicate(this.config, this.keepLastRow));
                    return new KeyedProcessOperator((KeyedProcessFunction)new RowTimeDeduplicateKeepFirstRowFunction(this.rowTypeInfo, this.stateRetentionTime, rowtimeIndex));
                }
                AsyncStateRowTimeDeduplicateFunction processFunction = new AsyncStateRowTimeDeduplicateFunction(this.rowTypeInfo, this.stateRetentionTime, rowtimeIndex, this.generateUpdateBefore, this.generateInsert(), this.keepLastRow);
                return new AsyncKeyedProcessOperator((KeyedProcessFunction)processFunction);
            }
            if (!this.keepLastRow && this.outputInsertOnly) {
                Preconditions.checkState((boolean)RankUtil.outputInsertOnlyInDeduplicate(this.config, this.keepLastRow));
                return new KeyedProcessOperator((KeyedProcessFunction)new RowTimeDeduplicateKeepFirstRowFunction(this.rowTypeInfo, this.stateRetentionTime, rowtimeIndex));
            }
            return new KeyedProcessOperator((KeyedProcessFunction)new RowTimeDeduplicateFunction(this.rowTypeInfo, this.stateRetentionTime, rowtimeIndex, this.generateUpdateBefore, this.generateInsert(), this.keepLastRow));
        }
    }

    private static abstract class DeduplicateOperatorTranslator {
        protected final ReadableConfig config;
        protected final InternalTypeInfo<RowData> rowTypeInfo;
        protected final TypeSerializer<RowData> typeSerializer;
        protected final boolean keepLastRow;
        protected final boolean outputInsertOnly;
        protected final boolean generateUpdateBefore;
        protected final long stateRetentionTime;

        protected DeduplicateOperatorTranslator(ReadableConfig config, InternalTypeInfo<RowData> rowTypeInfo, TypeSerializer<RowData> typeSerializer, boolean keepLastRow, boolean outputInsertOnly, boolean generateUpdateBefore, long stateRetentionTime) {
            this.config = config;
            this.rowTypeInfo = rowTypeInfo;
            this.typeSerializer = typeSerializer;
            this.keepLastRow = keepLastRow;
            this.outputInsertOnly = outputInsertOnly;
            this.generateUpdateBefore = generateUpdateBefore;
            this.stateRetentionTime = stateRetentionTime;
        }

        protected boolean generateInsert() {
            return (Boolean)this.config.get(ExecutionConfigOptions.TABLE_EXEC_DEDUPLICATE_INSERT_UPDATE_AFTER_SENSITIVE_ENABLED);
        }

        protected boolean isMiniBatchEnabled() {
            return (Boolean)this.config.get(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED);
        }

        protected boolean isCompactChanges() {
            return (Boolean)this.config.get(ExecutionConfigOptions.TABLE_EXEC_DEDUPLICATE_MINIBATCH_COMPACT_CHANGES_ENABLED);
        }

        protected boolean isAsyncStateEnabled() {
            return (Boolean)this.config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_STATE_ENABLED);
        }

        protected long getMiniBatchSize() {
            if (this.isMiniBatchEnabled()) {
                long size = (Long)this.config.get(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE);
                Preconditions.checkArgument((size > 0L ? 1 : 0) != 0, (Object)(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE.key() + " should be greater than 0."));
                return size;
            }
            return -1L;
        }

        abstract OneInputStreamOperator<RowData, RowData> createDeduplicateOperator();
    }
}

