/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.strategy;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.runtime.scheduler.adaptivebatch.OperatorsFinished;
import org.apache.flink.streaming.api.graph.StreamGraphContext;
import org.apache.flink.streaming.api.graph.util.ImmutableStreamEdge;
import org.apache.flink.streaming.api.graph.util.ImmutableStreamNode;
import org.apache.flink.streaming.api.graph.util.StreamEdgeUpdateRequestInfo;
import org.apache.flink.streaming.api.graph.util.StreamNodeUpdateRequestInfo;
import org.apache.flink.table.runtime.operators.join.adaptive.AdaptiveJoin;
import org.apache.flink.table.runtime.strategy.BaseAdaptiveJoinOperatorOptimizationStrategy;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostProcessAdaptiveJoinStrategy
extends BaseAdaptiveJoinOperatorOptimizationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(PostProcessAdaptiveJoinStrategy.class);

    public boolean onOperatorsFinished(OperatorsFinished operatorsFinished, StreamGraphContext context) {
        this.visitDownstreamAdaptiveJoinNode(operatorsFinished, context);
        return true;
    }

    @Override
    protected void tryOptimizeAdaptiveJoin(OperatorsFinished operatorsFinished, StreamGraphContext context, ImmutableStreamNode adaptiveJoinNode, List<ImmutableStreamEdge> upstreamStreamEdges, AdaptiveJoin adaptiveJoin) {
        if (context.checkUpstreamNodesFinished(adaptiveJoinNode, null)) {
            if (adaptiveJoin.shouldReorderInputs()) {
                if (!context.modifyStreamEdge(PostProcessAdaptiveJoinStrategy.generateStreamEdgeUpdateRequestInfosForInputsReordered(adaptiveJoinNode)) || !context.modifyStreamNode(this.generateStreamNodeUpdateRequestInfosForInputsReordered(adaptiveJoinNode))) {
                    throw new RuntimeException("Unexpected error occurs while reordering the inputs of the adaptive join node, potentially leading to data inaccuracies. Exceptions will be thrown.");
                }
                LOG.info("Reordered the inputs of the adaptive join node {}.", (Object)adaptiveJoinNode.getId());
            }
            ReadableConfig config = context.getStreamGraph().getConfiguration();
            ClassLoader userClassLoader = context.getStreamGraph().getUserClassLoader();
            adaptiveJoin.genOperatorFactory(userClassLoader, config);
        }
    }

    private static List<StreamEdgeUpdateRequestInfo> generateStreamEdgeUpdateRequestInfosForInputsReordered(ImmutableStreamNode adaptiveJoinNode) {
        ArrayList<StreamEdgeUpdateRequestInfo> streamEdgeUpdateRequestInfos = new ArrayList<StreamEdgeUpdateRequestInfo>();
        for (ImmutableStreamEdge inEdge : adaptiveJoinNode.getInEdges()) {
            StreamEdgeUpdateRequestInfo streamEdgeUpdateRequestInfo = new StreamEdgeUpdateRequestInfo(inEdge.getEdgeId(), Integer.valueOf(inEdge.getSourceId()), Integer.valueOf(inEdge.getTargetId()));
            streamEdgeUpdateRequestInfo.withTypeNumber(inEdge.getTypeNumber() == 1 ? 2 : 1);
            streamEdgeUpdateRequestInfos.add(streamEdgeUpdateRequestInfo);
        }
        return streamEdgeUpdateRequestInfos;
    }

    private List<StreamNodeUpdateRequestInfo> generateStreamNodeUpdateRequestInfosForInputsReordered(ImmutableStreamNode modifiedNode) {
        ArrayList<StreamNodeUpdateRequestInfo> streamEdgeUpdateRequestInfos = new ArrayList<StreamNodeUpdateRequestInfo>();
        TypeSerializer[] typeSerializers = modifiedNode.getTypeSerializersIn();
        Preconditions.checkState((typeSerializers.length == 2 ? 1 : 0) != 0, (Object)String.format("Adaptive join currently only supports two inputs, but the join node [%s] has received %s inputs.", modifiedNode.getId(), typeSerializers.length));
        TypeSerializer[] swappedTypeSerializers = new TypeSerializer[]{typeSerializers[1], typeSerializers[0]};
        StreamNodeUpdateRequestInfo requestInfo = new StreamNodeUpdateRequestInfo(Integer.valueOf(modifiedNode.getId())).withTypeSerializersIn(swappedTypeSerializers);
        streamEdgeUpdateRequestInfos.add(requestInfo);
        return streamEdgeUpdateRequestInfos;
    }
}

