/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.metrics.Counter;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.functions.KeyedProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRowTimeUnboundedPrecedingOver<K>
extends KeyedProcessFunctionWithCleanupState<K, RowData, RowData> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRowTimeUnboundedPrecedingOver.class);
    private final GeneratedAggsHandleFunction genAggsHandler;
    private final LogicalType[] accTypes;
    private final LogicalType[] inputFieldTypes;
    private final int rowTimeIdx;
    protected transient JoinedRowData output;
    private transient ValueState<RowData> accState;
    private transient MapState<Long, List<RowData>> inputState;
    private transient LinkedList<Long> sortedTimestamps;
    protected transient AggsHandleFunction function;
    private static final String LATE_ELEMENTS_DROPPED_METRIC_NAME = "numLateRecordsDropped";
    private transient Counter numLateRecordsDropped;

    @VisibleForTesting
    protected Counter getCounter() {
        return this.numLateRecordsDropped;
    }

    public AbstractRowTimeUnboundedPrecedingOver(long minRetentionTime, long maxRetentionTime, GeneratedAggsHandleFunction genAggsHandler, LogicalType[] accTypes, LogicalType[] inputFieldTypes, int rowTimeIdx) {
        super(minRetentionTime, maxRetentionTime);
        this.genAggsHandler = genAggsHandler;
        this.accTypes = accTypes;
        this.inputFieldTypes = inputFieldTypes;
        this.rowTimeIdx = rowTimeIdx;
    }

    public void open(OpenContext openContext) throws Exception {
        this.function = (AggsHandleFunction)this.genAggsHandler.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.function.open(new PerKeyStateDataViewStore(this.getRuntimeContext()));
        this.output = new JoinedRowData();
        this.sortedTimestamps = new LinkedList();
        InternalTypeInfo<RowData> accTypeInfo = InternalTypeInfo.ofFields(this.accTypes);
        ValueStateDescriptor accStateDesc = new ValueStateDescriptor("accState", accTypeInfo);
        this.accState = this.getRuntimeContext().getState(accStateDesc);
        InternalTypeInfo<RowData> inputType = InternalTypeInfo.ofFields(this.inputFieldTypes);
        ListTypeInfo rowListTypeInfo = new ListTypeInfo(inputType);
        MapStateDescriptor inputStateDesc = new MapStateDescriptor("inputState", Types.LONG, (TypeInformation)rowListTypeInfo);
        this.inputState = this.getRuntimeContext().getMapState(inputStateDesc);
        this.initCleanupTimeState("RowTimeUnboundedOverCleanupTime");
        this.numLateRecordsDropped = this.getRuntimeContext().getMetricGroup().counter(LATE_ELEMENTS_DROPPED_METRIC_NAME);
    }

    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
        long timestamp = input.getLong(this.rowTimeIdx);
        long curWatermark = ctx.timerService().currentWatermark();
        if (timestamp > curWatermark) {
            long triggerTs = curWatermark < 0L ? 0L : curWatermark + 1L;
            ctx.timerService().registerEventTimeTimer(triggerTs);
            ArrayList<RowData> rowList = (ArrayList<RowData>)this.inputState.get((Object)timestamp);
            if (rowList == null) {
                rowList = new ArrayList<RowData>();
            }
            rowList.add(input);
            this.inputState.put((Object)timestamp, rowList);
        } else {
            this.numLateRecordsDropped.inc();
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<RowData> out) throws Exception {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.stateCleaningEnabled) {
                if (this.inputState.isEmpty()) {
                    this.cleanupState(new State[]{this.inputState, this.accState});
                    this.function.cleanup();
                } else {
                    this.registerProcessingCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        Iterator keyIterator = this.inputState.keys().iterator();
        if (keyIterator.hasNext()) {
            Long curWatermark = ctx.timerService().currentWatermark();
            boolean existEarlyRecord = false;
            do {
                Long recordTime;
                if ((recordTime = (Long)keyIterator.next()) <= curWatermark) {
                    this.insertToSortedList(recordTime);
                    continue;
                }
                existEarlyRecord = true;
            } while (keyIterator.hasNext());
            RowData lastAccumulator = (RowData)this.accState.value();
            if (lastAccumulator == null) {
                lastAccumulator = this.function.createAccumulators();
            }
            this.function.setAccumulators(lastAccumulator);
            while (!this.sortedTimestamps.isEmpty()) {
                Long curTimestamp = this.sortedTimestamps.removeFirst();
                List curRowList = (List)this.inputState.get((Object)curTimestamp);
                if (curRowList != null) {
                    this.processElementsWithSameTimestamp(curRowList, out);
                } else {
                    LOG.warn("The state is cleared because of state ttl. This will result in incorrect result. You can increase the state ttl to avoid this.");
                }
                this.inputState.remove((Object)curTimestamp);
            }
            lastAccumulator = this.function.getAccumulators();
            this.accState.update((Object)lastAccumulator);
            if (existEarlyRecord) {
                ctx.timerService().registerEventTimeTimer(curWatermark + 1L);
            }
        }
        this.registerProcessingCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    private void insertToSortedList(Long recordTimestamp) {
        ListIterator<Long> listIterator = this.sortedTimestamps.listIterator(this.sortedTimestamps.size());
        boolean isContinue = true;
        while (listIterator.hasPrevious() && isContinue) {
            Long timestamp = listIterator.previous();
            if (recordTimestamp < timestamp) continue;
            listIterator.next();
            listIterator.add(recordTimestamp);
            isContinue = false;
        }
        if (isContinue) {
            this.sortedTimestamps.addFirst(recordTimestamp);
        }
    }

    protected abstract void processElementsWithSameTimestamp(List<RowData> var1, Collector<RowData> var2) throws Exception;

    public void close() throws Exception {
        if (null != this.function) {
            this.function.close();
        }
    }
}

