/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway;

import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.client.config.ResultMode;
import org.apache.flink.table.client.config.SqlClientOptions;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.StatementResult;
import org.apache.flink.table.client.gateway.result.ChangelogCollectResult;
import org.apache.flink.table.client.gateway.result.DynamicResult;
import org.apache.flink.table.client.gateway.result.MaterializedCollectBatchResult;
import org.apache.flink.table.client.gateway.result.MaterializedCollectStreamResult;
import org.apache.flink.table.utils.print.RowDataToStringConverter;

public class ResultDescriptor {
    private final StatementResult tableResult;
    private final ReadableConfig config;

    public ResultDescriptor(StatementResult tableResult, ReadableConfig config) {
        this.tableResult = tableResult;
        this.config = config;
    }

    public <T extends DynamicResult> T createResult() {
        ResultMode resultMode = (ResultMode)((Object)this.config.get(SqlClientOptions.EXECUTION_RESULT_MODE));
        boolean isStreaming = ((RuntimeExecutionMode)this.config.get(ExecutionOptions.RUNTIME_MODE)).equals((Object)RuntimeExecutionMode.STREAMING);
        if (resultMode.equals((Object)ResultMode.CHANGELOG) && !isStreaming) {
            throw new SqlExecutionException("Results of batch queries can only be served in table or tableau mode.");
        }
        switch (resultMode) {
            case CHANGELOG: 
            case TABLEAU: {
                return (T)new ChangelogCollectResult(this.tableResult);
            }
            case TABLE: {
                Integer maxRows = (Integer)this.config.get(SqlClientOptions.EXECUTION_MAX_TABLE_RESULT_ROWS);
                if (isStreaming) {
                    return (T)new MaterializedCollectStreamResult(this.tableResult, maxRows);
                }
                return (T)new MaterializedCollectBatchResult(this.tableResult, maxRows);
            }
        }
        throw new SqlExecutionException(String.format("Unknown value '%s' for option '%s'.", new Object[]{resultMode, SqlClientOptions.EXECUTION_RESULT_MODE.key()}));
    }

    public ResolvedSchema getResultSchema() {
        return this.tableResult.getResultSchema();
    }

    public boolean isMaterialized() {
        return ((ResultMode)((Object)this.config.get(SqlClientOptions.EXECUTION_RESULT_MODE))).equals((Object)ResultMode.TABLE);
    }

    public boolean isTableauMode() {
        return ((ResultMode)((Object)this.config.get(SqlClientOptions.EXECUTION_RESULT_MODE))).equals((Object)ResultMode.TABLEAU);
    }

    public boolean isStreamingMode() {
        return ((RuntimeExecutionMode)this.config.get(ExecutionOptions.RUNTIME_MODE)).equals((Object)RuntimeExecutionMode.STREAMING);
    }

    public int maxColumnWidth() {
        return (Integer)this.config.get(SqlClientOptions.DISPLAY_MAX_COLUMN_WIDTH);
    }

    public RowDataToStringConverter getRowDataStringConverter() {
        return this.tableResult.getRowDataToStringConverter();
    }
}

