/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem;

import flex2.compiler.io.FileUtil;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.MimeMappings;
import flex2.tools.oem.VirtualLocalFileSystem;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class VirtualLocalFile
implements VirtualFile {
    String text;
    private File parent;
    private String name;
    private String mimeType;
    long lastModified;
    private VirtualLocalFileSystem fs;

    VirtualLocalFile(String name, String text, File parent, long lastModified, VirtualLocalFileSystem fs) {
        this.name = name;
        this.text = text;
        this.parent = FileUtil.getCanonicalFile(parent);
        this.lastModified = lastModified;
        this.fs = fs;
        assert (this.parent.isDirectory());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameForReporting() {
        return this.getName();
    }

    @Override
    public String getURL() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getParent() {
        return FileUtil.getCanonicalPath(this.parent);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public long size() {
        return this.text == null ? 0L : (long)this.text.length();
    }

    @Override
    public String getMimeType() {
        if (this.mimeType == null) {
            this.mimeType = MimeMappings.getMimeType(this.name);
        }
        return this.mimeType;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.text == null ? new byte[]{} : this.text.getBytes("UTF-8"));
    }

    @Override
    public byte[] toByteArray() throws IOException {
        return this.text == null ? new byte[]{} : this.text.getBytes("UTF-8");
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public VirtualFile resolve(String relativeStr) {
        return this.fs.resolve(this, relativeStr);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof VirtualLocalFile) {
            return this == obj || this.getName().equals(((VirtualLocalFile)obj).getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean isTextBased() {
        return true;
    }

    public String toString() {
        return this.text;
    }
}

