/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.amd;

import java.io.FilterWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flex.compiler.codegen.js.amd.IJSAMDDocEmitter;
import org.apache.flex.compiler.codegen.js.amd.IJSAMDEmitter;
import org.apache.flex.compiler.definitions.IAccessorDefinition;
import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.definitions.IConstantDefinition;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.IFunctionDefinition;
import org.apache.flex.compiler.definitions.IInterfaceDefinition;
import org.apache.flex.compiler.definitions.IPackageDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.definitions.IVariableDefinition;
import org.apache.flex.compiler.definitions.references.IReference;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSEmitter;
import org.apache.flex.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.amd.ExportWriter;
import org.apache.flex.compiler.internal.codegen.js.amd.JSAMDEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.amd.TempTools;
import org.apache.flex.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.flex.compiler.internal.definitions.ClassTraitsDefinition;
import org.apache.flex.compiler.internal.tree.as.FunctionCallNode;
import org.apache.flex.compiler.internal.tree.as.FunctionNode;
import org.apache.flex.compiler.internal.tree.as.IdentifierNode;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.scopes.IASScope;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IAccessorNode;
import org.apache.flex.compiler.tree.as.IBlockNode;
import org.apache.flex.compiler.tree.as.IClassNode;
import org.apache.flex.compiler.tree.as.IContainerNode;
import org.apache.flex.compiler.tree.as.IDefinitionNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.IFunctionCallNode;
import org.apache.flex.compiler.tree.as.IFunctionNode;
import org.apache.flex.compiler.tree.as.IGetterNode;
import org.apache.flex.compiler.tree.as.IIdentifierNode;
import org.apache.flex.compiler.tree.as.IInterfaceNode;
import org.apache.flex.compiler.tree.as.ILanguageIdentifierNode;
import org.apache.flex.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.flex.compiler.tree.as.IParameterNode;
import org.apache.flex.compiler.tree.as.ISetterNode;
import org.apache.flex.compiler.tree.as.ITypeNode;
import org.apache.flex.compiler.tree.as.IVariableNode;
import org.apache.flex.compiler.utils.NativeUtils;

public class JSAMDEmitter
extends JSEmitter
implements IJSAMDEmitter {
    private Map<String, IDefinitionNode> foundAccessors = new HashMap<String, IDefinitionNode>();
    private int inheritenceLevel = -1;
    private ExportWriter exportWriter;
    private boolean initializingFieldsInConstructor;
    private List<IDefinition> baseClassCalls = new ArrayList<IDefinition>();

    StringBuilder builder() {
        return this.getBuilder();
    }

    IJSAMDDocEmitter getDoc() {
        return (IJSAMDDocEmitter)this.getDocEmitter();
    }

    public JSAMDEmitter(FilterWriter out) {
        super(out);
        this.exportWriter = new ExportWriter(this);
    }

    @Override
    public void emitPackageHeader(IPackageDefinition definition) {
        this.setBufferWrite(true);
        this.write(JSAMDEmitterTokens.DEFINE);
        this.write(ASEmitterTokens.PAREN_OPEN);
        IASScope containedScope = definition.getContainedScope();
        ITypeDefinition type = this.findType(containedScope.getAllLocalDefinitions());
        if (type == null) {
            return;
        }
        this.exportWriter.addFrameworkDependencies();
        this.exportWriter.addImports(type);
        this.exportWriter.queueExports(type, true);
        this.writeToken(ASEmitterTokens.COMMA);
    }

    @Override
    public void emitPackageHeaderContents(IPackageDefinition definition) {
    }

    @Override
    public void emitPackageContents(IPackageDefinition definition) {
        IASScope containedScope = definition.getContainedScope();
        ITypeDefinition type = this.findType(containedScope.getAllLocalDefinitions());
        if (type == null) {
            return;
        }
        this.write("function($exports");
        this.exportWriter.queueExports(type, false);
        this.write(") {");
        this.indentPush();
        this.writeNewline();
        this.write("\"use strict\"; ");
        this.writeNewline();
        ITypeNode tnode = this.findTypeNode(definition.getNode());
        if (tnode != null) {
            this.getWalker().walk((IASNode)tnode);
        }
        this.indentPop();
        this.writeNewline();
        this.write("}");
    }

    @Override
    public void emitPackageFooter(IPackageDefinition definition) {
        IASScope containedScope = definition.getContainedScope();
        ITypeDefinition type = this.findType(containedScope.getAllLocalDefinitions());
        if (type == null) {
            return;
        }
        this.exportWriter.writeExports(type, true);
        this.exportWriter.writeExports(type, false);
        this.write(");");
        this.flushBuilder();
    }

    private void emitConstructor(IFunctionNode node) {
        FunctionNode fn = (FunctionNode)node;
        fn.parseFunctionBody(this.getProblems());
        this.write("function ");
        this.write(node.getName());
        this.emitParameters(node.getParametersContainerNode());
        if (!JSAMDEmitter.isImplicit((IContainerNode)node.getScopedNode())) {
            this.emitMethodScope(node.getScopedNode());
        }
    }

    @Override
    public void emitInterface(IInterfaceNode node) {
        IInterfaceDefinition definition = node.getDefinition();
        String interfaceName = definition.getBaseName();
        this.write("AS3.interface_($exports, {");
        this.indentPush();
        this.writeNewline();
        this.write("package_: \"");
        this.write(definition.getPackageName());
        this.write("\",");
        this.writeNewline();
        this.write("interface_: \"");
        this.write(interfaceName);
        this.write("\"");
        IReference[] references = definition.getExtendedInterfaceReferences();
        int len = references.length;
        if (len > 0) {
            this.writeNewline();
            this.write("extends_: [");
            this.indentPush();
            this.writeNewline();
            int i = 0;
            for (IReference reference : references) {
                this.write(reference.getName());
                if (i < len - 1) {
                    this.write(",");
                    this.writeNewline();
                }
                ++i;
            }
            this.indentPop();
            this.writeNewline();
            this.write("]");
        }
        this.indentPop();
        this.writeNewline();
        this.write("});");
    }

    @Override
    public void emitClass(IClassNode node) {
        boolean hasSuper;
        IClassDefinition definition = node.getDefinition();
        this.getModel().setCurrentClass(definition);
        String className = definition.getBaseName();
        this.write("AS3.compilationUnit($exports, function($primaryDeclaration){");
        this.indentPush();
        this.writeNewline();
        this.emitConstructor((IFunctionNode)definition.getConstructor().getNode());
        this.writeNewline();
        IReference baseClassReference = definition.getBaseClassReference();
        boolean bl = hasSuper = baseClassReference != null && !baseClassReference.getName().equals("Object");
        if (hasSuper) {
            String baseName = baseClassReference.getName();
            this.write("var Super = (" + baseName + "._ || " + baseName + "._$get());");
            this.writeNewline();
            this.write("var super$ = Super.prototype;");
            this.writeNewline();
        }
        this.write("$primaryDeclaration(AS3.class_({");
        this.indentPush();
        this.writeNewline();
        this.write("package_: \"" + definition.getPackageName() + "\",");
        this.writeNewline();
        this.write("class_: \"" + definition.getBaseName() + "\",");
        this.writeNewline();
        if (hasSuper) {
            this.write("extends_: Super,");
            this.writeNewline();
        }
        IReference[] references = definition.getImplementedInterfaceReferences();
        int len = references.length;
        this.write("implements_:");
        this.write(" [");
        if (len > 0) {
            this.indentPush();
            this.writeNewline();
        }
        int i = 0;
        for (IReference reference : references) {
            this.write(reference.getName());
            this.exportWriter.addDependency(reference.getName(), reference.getDisplayString(), false, false);
            if (i < len - 1) {
                this.write(",");
                this.writeNewline();
            }
            ++i;
        }
        if (len > 0) {
            this.indentPop();
            this.writeNewline();
        }
        this.write("],");
        this.writeNewline();
        IDefinitionNode[] members = node.getAllMemberNodes();
        this.write("members: {");
        this.indentPush();
        this.writeNewline();
        this.write("constructor: " + className);
        if (members.length > 0) {
            this.write(",");
            this.writeNewline();
        }
        ArrayList<IDefinitionNode> instanceMembers = new ArrayList<IDefinitionNode>();
        ArrayList<IDefinitionNode> staticMembers = new ArrayList<IDefinitionNode>();
        ArrayList<IASNode> staticStatements = new ArrayList<IASNode>();
        TempTools.fillInstanceMembers(members, instanceMembers);
        TempTools.fillStaticMembers(members, staticMembers, true, false);
        TempTools.fillStaticStatements(node, staticStatements, false);
        len = instanceMembers.size();
        i = 0;
        for (IDefinitionNode mnode : instanceMembers) {
            if (mnode instanceof IAccessorNode) {
                if (this.foundAccessors.containsKey(mnode.getName())) {
                    --len;
                    continue;
                }
                this.getWalker().walk((IASNode)mnode);
            } else if (mnode instanceof IFunctionNode) {
                this.getWalker().walk((IASNode)mnode);
            } else if (mnode instanceof IVariableNode) {
                this.getWalker().walk((IASNode)mnode);
            } else {
                this.write(mnode.getName());
            }
            if (i < len - 1) {
                this.write(",");
                this.writeNewline();
            }
            ++i;
        }
        len = this.baseClassCalls.size();
        i = 0;
        if (len > 0) {
            this.write(",");
            this.writeNewline();
        }
        for (IDefinition baseCall : this.baseClassCalls) {
            this.write(baseCall.getBaseName() + "$" + this.inheritenceLevel + ": super$." + baseCall.getBaseName());
            if (i >= len - 1) continue;
            this.write(",");
            this.writeNewline();
        }
        this.indentPop();
        this.writeNewline();
        this.write("},");
        this.writeNewline();
        len = staticMembers.size();
        this.write("staticMembers: {");
        this.indentPush();
        this.writeNewline();
        i = 0;
        for (IDefinitionNode mnode : staticMembers) {
            if (mnode instanceof IAccessorNode) {
                if (this.foundAccessors.containsKey(mnode.getName())) continue;
                this.foundAccessors.put(mnode.getName(), mnode);
                this.getWalker().walk((IASNode)mnode);
            } else if (mnode instanceof IFunctionNode) {
                this.getWalker().walk((IASNode)mnode);
            } else if (mnode instanceof IVariableNode) {
                this.getWalker().walk((IASNode)mnode);
            }
            if (i < len - 1) {
                this.write(",");
                this.writeNewline();
            }
            ++i;
        }
        this.indentPop();
        if (len > 0) {
            this.writeNewline();
        }
        this.write("}");
        this.indentPop();
        this.writeNewline();
        this.write("}));");
        len = staticStatements.size();
        if (len > 0) {
            this.writeNewline();
        }
        i = 0;
        for (IASNode statement : staticStatements) {
            this.getWalker().walk(statement);
            if (!(statement instanceof IBlockNode)) {
                this.write(";");
            }
            if (i < len - 1) {
                this.writeNewline();
            }
            ++i;
        }
        this.indentPop();
        this.writeNewline();
        this.write("});");
    }

    @Override
    public void emitField(IVariableNode node) {
        IVariableDefinition definition = (IVariableDefinition)node.getDefinition();
        if (definition.isStatic()) {
            IClassDefinition parent = (IClassDefinition)definition.getParent();
            this.write(parent.getBaseName());
            this.write(".");
            this.write(definition.getBaseName());
            this.write(" = ");
            this.emitFieldInitialValue(node);
            return;
        }
        String name = this.toPrivateName((IDefinition)definition);
        this.write(name);
        this.write(": ");
        this.write("{");
        this.indentPush();
        this.writeNewline();
        this.write("value:");
        this.emitFieldInitialValue(node);
        this.write(",");
        this.writeNewline();
        this.write("writable:");
        this.write(!(definition instanceof IConstantDefinition) ? "true" : "false");
        this.indentPop();
        this.writeNewline();
        this.write("}");
    }

    private void emitFieldInitialValue(IVariableNode node) {
        ICompilerProject project = this.getWalker().getProject();
        IVariableDefinition definition = (IVariableDefinition)node.getDefinition();
        IExpressionNode valueNode = node.getAssignedValueNode();
        if (valueNode != null) {
            this.getWalker().walk((IASNode)valueNode);
        } else {
            this.write(TempTools.toInitialValue(definition, project));
        }
    }

    @Override
    public void emitGetAccessor(IGetterNode node) {
        if (this.foundAccessors.containsKey(node.getName())) {
            return;
        }
        this.foundAccessors.put(node.getName(), (IDefinitionNode)node);
        ICompilerProject project = this.getWalker().getProject();
        IAccessorDefinition getter = (IAccessorDefinition)node.getDefinition();
        IAccessorDefinition setter = getter.resolveCorrespondingAccessor(project);
        this.emitGetterSetterPair(getter, setter);
    }

    @Override
    public void emitSetAccessor(ISetterNode node) {
        if (this.foundAccessors.containsKey(node.getName())) {
            return;
        }
        this.foundAccessors.put(node.getName(), (IDefinitionNode)node);
        ICompilerProject project = this.getWalker().getProject();
        IAccessorDefinition setter = (IAccessorDefinition)node.getDefinition();
        IAccessorDefinition getter = setter.resolveCorrespondingAccessor(project);
        this.emitGetterSetterPair(getter, setter);
    }

    private void emitGetterSetterPair(IAccessorDefinition getter, IAccessorDefinition setter) {
        this.write(getter.getBaseName());
        this.write(": {");
        this.indentPush();
        this.writeNewline();
        if (getter != null) {
            this.emitAccessor("get", getter);
        }
        if (setter != null) {
            this.write(",");
            this.writeNewline();
            this.emitAccessor("set", setter);
        }
        this.indentPop();
        this.writeNewline();
        this.write("}");
    }

    protected void emitAccessor(String kind, IAccessorDefinition definition) {
        IFunctionNode fnode = definition.getFunctionNode();
        FunctionNode fn = (FunctionNode)fnode;
        fn.parseFunctionBody(new ArrayList());
        this.write(kind + ": function ");
        this.write(definition.getBaseName() + "$" + kind);
        this.emitParameters(fnode.getParametersContainerNode());
        this.emitMethodScope(fnode.getScopedNode());
    }

    @Override
    public void emitMethod(IFunctionNode node) {
        if (node.isConstructor()) {
            this.emitConstructor(node);
            return;
        }
        FunctionNode fn = (FunctionNode)node;
        fn.parseFunctionBody(new ArrayList());
        IFunctionDefinition definition = node.getDefinition();
        String name = this.toPrivateName((IDefinition)definition);
        this.write(name);
        this.write(":");
        this.write(" function ");
        this.write(node.getName());
        this.emitParameters(node.getParametersContainerNode());
        this.emitMethodScope(node.getScopedNode());
    }

    @Override
    public void emitFunctionBlockHeader(IFunctionNode node) {
        IFunctionDefinition definition = node.getDefinition();
        if (node.isConstructor()) {
            this.initializingFieldsInConstructor = true;
            IClassDefinition type = (IClassDefinition)definition.getAncestorOfType(IClassDefinition.class);
            List<IVariableDefinition> fields = TempTools.getFields(type, true);
            for (IVariableDefinition field : fields) {
                if (TempTools.isVariableAParameter(field, definition.getParameters())) continue;
                this.write("this.");
                this.write(field.getBaseName());
                this.write(" = ");
                this.emitFieldInitialValue((IVariableNode)field.getNode());
                this.write(";");
                this.writeNewline();
            }
            this.initializingFieldsInConstructor = false;
        }
        this.emitDefaultParameterCodeBlock(node);
    }

    private void emitDefaultParameterCodeBlock(IFunctionNode node) {
        IParameterNode[] pnodes = node.getParameterNodes();
        Map<Integer, IParameterNode> defaults = TempTools.getDefaults(pnodes);
        if (pnodes.length == 0) {
            return;
        }
        if (defaults != null) {
            boolean hasBody;
            boolean bl = hasBody = node.getScopedNode().getChildCount() > 0;
            if (!hasBody) {
                this.indentPush();
                this.write(ASEmitterTokens.INDENT);
            }
            StringBuilder code = new StringBuilder();
            ArrayList<IParameterNode> parameters = new ArrayList<IParameterNode>(defaults.values());
            Collections.reverse(parameters);
            int len = defaults.size();
            for (IParameterNode pnode : parameters) {
                if (pnode != null) {
                    code.setLength(0);
                    code.append(ASEmitterTokens.IF.getToken());
                    code.append(ASEmitterTokens.SPACE.getToken());
                    code.append(ASEmitterTokens.PAREN_OPEN.getToken());
                    code.append(JSEmitterTokens.ARGUMENTS.getToken());
                    code.append(ASEmitterTokens.MEMBER_ACCESS.getToken());
                    code.append(JSAMDEmitterTokens.LENGTH.getToken());
                    code.append(ASEmitterTokens.SPACE.getToken());
                    code.append(ASEmitterTokens.LESS_THAN.getToken());
                    code.append(ASEmitterTokens.SPACE.getToken());
                    code.append(len);
                    code.append(ASEmitterTokens.PAREN_CLOSE.getToken());
                    code.append(ASEmitterTokens.SPACE.getToken());
                    code.append(ASEmitterTokens.BLOCK_OPEN.getToken());
                    this.write(code.toString());
                    this.indentPush();
                    this.writeNewline();
                }
                --len;
            }
            Collections.reverse(parameters);
            int n = parameters.size();
            for (int i = 0; i < n; ++i) {
                IParameterNode pnode = (IParameterNode)parameters.get(i);
                if (pnode == null) continue;
                code.setLength(0);
                code.append(pnode.getName());
                code.append(ASEmitterTokens.SPACE.getToken());
                code.append(ASEmitterTokens.EQUAL.getToken());
                code.append(ASEmitterTokens.SPACE.getToken());
                code.append(pnode.getDefaultValue());
                code.append(ASEmitterTokens.SEMICOLON.getToken());
                this.write(code.toString());
                this.indentPop();
                this.writeNewline();
                this.write(ASEmitterTokens.BLOCK_CLOSE);
                if (i == n - 1 && !hasBody) {
                    this.indentPop();
                }
                this.writeNewline();
            }
        }
    }

    @Override
    public void emitParameter(IParameterNode node) {
        this.getWalker().walk((IASNode)node.getNameExpressionNode());
    }

    @Override
    public void emitMemberAccessExpression(IMemberAccessExpressionNode node) {
        this.getWalker().walk((IASNode)node.getLeftOperandNode());
        if (!(node.getLeftOperandNode() instanceof ILanguageIdentifierNode)) {
            this.write(node.getOperator().getOperatorText());
        }
        this.getWalker().walk((IASNode)node.getRightOperandNode());
    }

    @Override
    public void emitFunctionCall(IFunctionCallNode node) {
        if (node.isNewExpression()) {
            this.write(ASEmitterTokens.NEW);
            this.write(ASEmitterTokens.SPACE);
        }
        this.getWalker().walk((IASNode)node.getNameNode());
        this.emitArguments((IContainerNode)node.getArgumentsNode());
    }

    @Override
    public void emitArguments(IContainerNode node) {
        IContainerNode newNode = node;
        FunctionCallNode fnode = (FunctionCallNode)node.getParent();
        if (TempTools.injectThisArgument(fnode, false)) {
            IdentifierNode thisNode = new IdentifierNode("this");
            newNode = EmitterUtils.insertArgumentsBefore(node, new IASNode[]{thisNode});
        }
        int len = newNode.getChildCount();
        this.write(ASEmitterTokens.PAREN_OPEN);
        for (int i = 0; i < len; ++i) {
            IExpressionNode inode = (IExpressionNode)newNode.getChild(i);
            if (inode.getNodeID() == ASTNodeID.IdentifierID) {
                this.emitArgumentIdentifier((IIdentifierNode)inode);
            } else {
                this.getWalker().walk((IASNode)inode);
            }
            if (i >= len - 1) continue;
            this.writeToken(ASEmitterTokens.COMMA);
        }
        this.write(ASEmitterTokens.PAREN_CLOSE);
    }

    private void emitArgumentIdentifier(IIdentifierNode node) {
        ITypeDefinition type = node.resolveType(this.getWalker().getProject());
        if (type instanceof ClassTraitsDefinition) {
            String qualifiedName = type.getQualifiedName();
            this.write(qualifiedName);
        } else {
            this.getWalker().walk((IASNode)node);
        }
    }

    @Override
    public void emitIdentifier(IIdentifierNode node) {
        ICompilerProject project = this.getWalker().getProject();
        IDefinition resolve = node.resolve(project);
        if (TempTools.isBinding(node, project)) {
            this.write("AS3.bind(this, \"" + this.toPrivateName(resolve) + "\")");
        } else {
            IExpressionNode leftBase = TempTools.getNode((IASNode)node, false, project);
            if (leftBase == node) {
                if (TempTools.isValidThis(node, project)) {
                    this.write("this.");
                }
                if (this.initializingFieldsInConstructor && resolve instanceof IClassDefinition) {
                    String name = resolve.getBaseName();
                    this.write("(" + name + "._ || " + name + "._$get())");
                    return;
                }
            }
            if (resolve != null) {
                IMemberAccessExpressionNode mnode;
                String name = this.toPrivateName(resolve);
                if (NativeUtils.isNative(name)) {
                    this.exportWriter.addDependency(name, name, true, false);
                }
                if (node.getParent() instanceof IMemberAccessExpressionNode && (mnode = (IMemberAccessExpressionNode)node.getParent()).getLeftOperandNode().getNodeID() == ASTNodeID.SuperID) {
                    IIdentifierNode lnode = (IIdentifierNode)mnode.getRightOperandNode();
                    IClassNode cnode = (IClassNode)node.getAncestorOfType(IClassNode.class);
                    this.initializeInheritenceLevel((IDefinition)cnode.getDefinition());
                    this.write("this.");
                    this.write(lnode.getName() + "$" + this.inheritenceLevel);
                    this.baseClassCalls.add(resolve);
                    return;
                }
                this.write(name);
            } else {
                this.write(node.getName());
            }
        }
    }

    @Override
    protected void emitType(IExpressionNode node) {
    }

    @Override
    public void emitLanguageIdentifier(ILanguageIdentifierNode node) {
        if (node.getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.ANY_TYPE) {
            this.write("");
        } else if (node.getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.REST) {
            this.write("");
        } else if (node.getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.SUPER) {
            IIdentifierNode inode = (IIdentifierNode)node;
            if (!(inode.getParent() instanceof IMemberAccessExpressionNode)) {
                this.write("Super.call");
            }
        } else if (node.getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.THIS) {
            this.write("");
        } else if (node.getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.VOID) {
            this.write("");
        }
    }

    private String toPrivateName(IDefinition definition) {
        if (definition instanceof ITypeDefinition) {
            return definition.getBaseName();
        }
        if (!definition.isPrivate()) {
            return definition.getBaseName();
        }
        this.initializeInheritenceLevel(definition);
        return definition.getBaseName() + "$" + this.inheritenceLevel;
    }

    void initializeInheritenceLevel(IDefinition definition) {
        if (this.inheritenceLevel != -1) {
            return;
        }
        IClassDefinition cdefinition = null;
        cdefinition = definition instanceof IClassDefinition ? (IClassDefinition)definition : (IClassDefinition)definition.getAncestorOfType(IClassDefinition.class);
        ICompilerProject project = this.getWalker().getProject();
        IClassDefinition[] ancestry = cdefinition.resolveAncestry(project);
        this.inheritenceLevel = ancestry.length - 1;
    }
}

