/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.graph;

import java.io.OutputStream;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.flex.compiler.internal.graph.IReportWriter;
import org.apache.flex.compiler.internal.projects.DependencyGraph;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.w3c.dom.Document;

public abstract class XMLGraphWriter
implements IReportWriter {
    protected DependencyGraph graph;
    protected Collection<ICompilationUnit> roots;
    protected Document doc;

    @Override
    public abstract void writeToStream(OutputStream var1, Collection<ICompilerProblem> var2) throws InterruptedException;

    protected void writeReport(OutputStream outStream) throws TransformerException {
        block2: {
            try {
                TransformerFactory tranFactory = TransformerFactory.newInstance();
                Transformer aTransformer = tranFactory.newTransformer();
                aTransformer.setOutputProperty("indent", "yes");
                DOMSource src = new DOMSource(this.doc);
                StreamResult dest = new StreamResult(outStream);
                aTransformer.transform(src, dest);
            }
            catch (TransformerConfigurationException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Programmer Error");
            }
        }
    }

    protected String formatXMLStyleQName(String qname) {
        StringBuilder sb = new StringBuilder(qname);
        int lastDotIndex = qname.lastIndexOf(46);
        if (lastDotIndex > -1) {
            sb.setCharAt(lastDotIndex, ':');
        }
        return sb.toString();
    }

    public XMLGraphWriter(DependencyGraph graph, Collection<ICompilationUnit> roots) {
        block2: {
            this.graph = graph;
            this.roots = roots;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder parser = factory.newDocumentBuilder();
                this.doc = parser.newDocument();
            }
            catch (ParserConfigurationException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Programmer error");
            }
        }
    }
}

