/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints;

import flex.management.runtime.messaging.endpoints.StreamingAMFEndpointControl;
import flex.messaging.MessageBroker;
import flex.messaging.endpoints.BaseStreamingHTTPEndpoint;
import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.endpoints.amf.BatchProcessFilter;
import flex.messaging.endpoints.amf.LegacyFilter;
import flex.messaging.endpoints.amf.MessageBrokerFilter;
import flex.messaging.endpoints.amf.SerializationFilter;
import flex.messaging.endpoints.amf.SessionFilter;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.io.amf.Amf3Output;
import flex.messaging.log.Log;
import flex.messaging.messages.Message;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class StreamingAMFEndpoint
extends BaseStreamingHTTPEndpoint {
    public static final String LOG_CATEGORY = "Endpoint.StreamingAMF";

    public StreamingAMFEndpoint() {
        this(false);
    }

    public StreamingAMFEndpoint(boolean enableManagement) {
        super(enableManagement);
    }

    @Override
    protected AMFFilter createFilterChain() {
        SerializationFilter serializationFilter = new SerializationFilter(this.getLogCategory());
        BatchProcessFilter batchFilter = new BatchProcessFilter();
        SessionFilter sessionFilter = this.sessionRewritingEnabled ? new SessionFilter() : null;
        LegacyFilter envelopeFilter = new LegacyFilter(this);
        MessageBrokerFilter messageBrokerFilter = new MessageBrokerFilter(this);
        serializationFilter.setNext(batchFilter);
        if (sessionFilter != null) {
            batchFilter.setNext(sessionFilter);
            sessionFilter.setNext(envelopeFilter);
        } else {
            batchFilter.setNext(envelopeFilter);
        }
        envelopeFilter.setNext(messageBrokerFilter);
        return serializationFilter;
    }

    @Override
    protected String getResponseContentType() {
        return "application/x-amf";
    }

    @Override
    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    @Override
    protected long getMessageSizeForPerformanceInfo(Message message) {
        DataOutputStream dataOutStream;
        block2: {
            Amf3Output amfOut = new Amf3Output(this.serializationContext);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            dataOutStream = new DataOutputStream(outStream);
            amfOut.setOutputStream(dataOutStream);
            try {
                amfOut.writeObject(message);
            }
            catch (IOException e) {
                if (!Log.isDebug()) break block2;
                this.log.debug("MPI exception while retrieving the size of the serialized message: " + e.toString());
            }
        }
        return dataOutStream.size();
    }

    @Override
    protected String getDeserializerClassName() {
        return "flex.messaging.io.amf.AmfMessageDeserializer";
    }

    @Override
    protected String getSerializerClassName() {
        return "flex.messaging.io.amf.AmfMessageSerializer";
    }

    @Override
    protected void setupEndpointControl(MessageBroker broker) {
        this.controller = new StreamingAMFEndpointControl(this, broker.getControl());
        this.controller.register();
        this.setControl(this.controller);
    }

    @Override
    protected void streamMessages(List messages, ServletOutputStream os, HttpServletResponse response) throws IOException {
        if (messages == null || messages.isEmpty()) {
            return;
        }
        TypeMarshallingContext.setTypeMarshaller(this.getTypeMarshaller());
        for (Message message : messages) {
            this.addPerformanceInfo(message);
            message = this.convertPushMessageToSmall(message);
            if (Log.isDebug()) {
                this.log.debug("Endpoint with id '" + this.getId() + "' is streaming message: " + message);
            }
            Amf3Output amfOut = new Amf3Output(this.serializationContext);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            DataOutputStream dataOutStream = new DataOutputStream(outStream);
            amfOut.setOutputStream(dataOutStream);
            amfOut.writeObject(message);
            dataOutStream.flush();
            byte[] messageBytes = outStream.toByteArray();
            this.streamChunk(messageBytes, os, response);
            if (!this.isManaged()) continue;
            ((StreamingAMFEndpointControl)this.controller).incrementPushCount();
        }
        TypeMarshallingContext.setTypeMarshaller(null);
    }
}

