/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.mcp.sink.data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.eventmesh.common.remote.offset.http.HttpRecordOffset;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.KeyValue;

public class McpConnectRecord
implements Serializable {
    private static final long serialVersionUID = 5271462532332251473L;
    private final String mcpRecordId = UUID.randomUUID().toString();
    private LocalDateTime createTime;
    private String type;
    private String eventId;
    private Object data;
    private KeyValue extensions;

    public String toString() {
        return "McpConnectRecord{createTime=" + this.createTime + ", mcpRecordId='" + this.mcpRecordId + ", type='" + this.type + ", eventId='" + this.eventId + ", data=" + this.data + ", extensions=" + this.extensions + '}';
    }

    public static McpConnectRecord convertConnectRecord(ConnectRecord record, String type) {
        Map offsetMap = new HashMap();
        if (record != null && record.getPosition() != null && record.getPosition().getRecordOffset() != null && HttpRecordOffset.class.equals((Object)record.getPosition().getRecordOffsetClazz())) {
            offsetMap = ((HttpRecordOffset)record.getPosition().getRecordOffset()).getOffsetMap();
        }
        String offset = "0";
        if (!offsetMap.isEmpty()) {
            offset = offsetMap.values().iterator().next().toString();
        }
        if (record.getData() instanceof byte[]) {
            String data = Base64.getEncoder().encodeToString((byte[])record.getData());
            record.addExtension("isBase64", (Object)true);
            return McpConnectRecord.builder().type(type).createTime(LocalDateTime.now()).eventId(type + "-" + offset).data(data).extensions(record.getExtensions()).build();
        }
        record.addExtension("isBase64", (Object)false);
        return McpConnectRecord.builder().type(type).createTime(LocalDateTime.now()).eventId(type + "-" + offset).data(record.getData()).extensions(record.getExtensions()).build();
    }

    @Generated
    McpConnectRecord(LocalDateTime createTime, String type, String eventId, Object data, KeyValue extensions) {
        this.createTime = createTime;
        this.type = type;
        this.eventId = eventId;
        this.data = data;
        this.extensions = extensions;
    }

    @Generated
    public static McpConnectRecordBuilder builder() {
        return new McpConnectRecordBuilder();
    }

    @Generated
    public String getMcpRecordId() {
        return this.mcpRecordId;
    }

    @Generated
    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getEventId() {
        return this.eventId;
    }

    @Generated
    public Object getData() {
        return this.data;
    }

    @Generated
    public KeyValue getExtensions() {
        return this.extensions;
    }

    @Generated
    public static class McpConnectRecordBuilder {
        @Generated
        private LocalDateTime createTime;
        @Generated
        private String type;
        @Generated
        private String eventId;
        @Generated
        private Object data;
        @Generated
        private KeyValue extensions;

        @Generated
        McpConnectRecordBuilder() {
        }

        @Generated
        public McpConnectRecordBuilder createTime(LocalDateTime createTime) {
            this.createTime = createTime;
            return this;
        }

        @Generated
        public McpConnectRecordBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public McpConnectRecordBuilder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        @Generated
        public McpConnectRecordBuilder data(Object data) {
            this.data = data;
            return this;
        }

        @Generated
        public McpConnectRecordBuilder extensions(KeyValue extensions) {
            this.extensions = extensions;
            return this;
        }

        @Generated
        public McpConnectRecord build() {
            return new McpConnectRecord(this.createTime, this.type, this.eventId, this.data, this.extensions);
        }

        @Generated
        public String toString() {
            return "McpConnectRecord.McpConnectRecordBuilder(createTime=" + this.createTime + ", type=" + this.type + ", eventId=" + this.eventId + ", data=" + this.data + ", extensions=" + this.extensions + ")";
        }
    }
}

