/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.profiler.util;

import com.navercorp.pinpoint.common.profiler.util.TransactionIdUtils;
import com.navercorp.pinpoint.common.util.IdValidateUtils;

public class TransactionId {
    private final String agentId;
    private final long agentStartTime;
    private final long transactionSequence;

    public TransactionId(String agentId, long agentStartTime, long transactionSequence) {
        if (!IdValidateUtils.validateId((String)agentId)) {
            throw new IllegalArgumentException("invalid agentId");
        }
        this.agentId = agentId;
        this.agentStartTime = agentStartTime;
        this.transactionSequence = transactionSequence;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public long getAgentStartTime() {
        return this.agentStartTime;
    }

    public long getTransactionSequence() {
        return this.transactionSequence;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionId that = (TransactionId)o;
        if (this.agentStartTime != that.agentStartTime) {
            return false;
        }
        if (this.transactionSequence != that.transactionSequence) {
            return false;
        }
        return this.agentId.equals(that.agentId);
    }

    public int hashCode() {
        int result = this.agentId.hashCode();
        result = 31 * result + (int)(this.agentStartTime ^ this.agentStartTime >>> 32);
        result = 31 * result + (int)(this.transactionSequence ^ this.transactionSequence >>> 32);
        return result;
    }

    public String toString() {
        return TransactionIdUtils.formatString(this);
    }
}

