/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.profiler.concurrent.executor;

import com.navercorp.pinpoint.common.profiler.concurrent.PinpointThreadFactory;
import com.navercorp.pinpoint.common.profiler.concurrent.executor.MultiConsumer;
import com.navercorp.pinpoint.common.profiler.concurrent.executor.SingleConsumer;
import com.navercorp.pinpoint.common.profiler.concurrent.executor.UnsafeArrayCollection;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsyncQueueingExecutor<T> {
    private final Logger logger;
    private final LinkedBlockingQueue<T> queue;
    private final AtomicBoolean isRun = new AtomicBoolean(true);
    private final Thread executeThread;
    private final String executorName;
    private final int maxDrainSize;
    private final Collection<T> drain;
    private final MultiConsumer<T> consumer;

    public AsyncQueueingExecutor(int queueSize, String executorName, Consumer<T> consumer) {
        this(queueSize, executorName, new SingleConsumer<T>(consumer));
    }

    public AsyncQueueingExecutor(int queueSize, String executorName, MultiConsumer<T> consumer) {
        Objects.requireNonNull(executorName, "executorName");
        this.logger = LogManager.getLogger((String)(this.getClass().getName() + "@" + executorName));
        this.maxDrainSize = 10;
        this.drain = new UnsafeArrayCollection<T>(this.maxDrainSize);
        this.queue = new LinkedBlockingQueue(queueSize);
        this.executeThread = this.createExecuteThread(executorName);
        this.executorName = this.executeThread.getName();
        this.consumer = Objects.requireNonNull(consumer, "consumer");
    }

    private Thread createExecuteThread(String executorName) {
        PinpointThreadFactory threadFactory = new PinpointThreadFactory(executorName, true);
        Thread thread = threadFactory.newThread(this::doAccept);
        thread.start();
        return thread;
    }

    private void doAccept() {
        long timeout = 2000L;
        block2: while (this.isRun()) {
            try {
                Collection<T> dtoList = this.getDrainQueue();
                int drainSize = this.takeN(dtoList, this.maxDrainSize);
                if (drainSize > 0) {
                    this.doAccept((T)dtoList);
                    continue;
                }
                while (this.isRun()) {
                    T dto = this.takeOne(timeout);
                    if (dto != null) {
                        this.doAccept(dto);
                        continue block2;
                    }
                    this.pollTimeout(timeout);
                }
            }
            catch (Throwable th) {
                this.logger.warn("{} doExecute(). Unexpected Error. Cause:{}", (Object)this.executorName, (Object)th.getMessage(), (Object)th);
            }
        }
        this.flushQueue();
    }

    private void flushQueue() {
        Collection<T> elementList;
        int drainSize;
        boolean debugEnabled = this.logger.isDebugEnabled();
        if (debugEnabled) {
            this.logger.debug("Loop is stop.");
        }
        while ((drainSize = this.takeN(elementList = this.getDrainQueue(), this.maxDrainSize)) != 0) {
            if (debugEnabled) {
                this.logger.debug("flushData size {}", (Object)drainSize);
            }
            this.doAccept((T)elementList);
        }
    }

    private T takeOne(long timeout) {
        try {
            return this.queue.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private int takeN(Collection<T> drain, int maxDrainSize) {
        return this.queue.drainTo(drain, maxDrainSize);
    }

    protected void pollTimeout(long timeout) {
    }

    public boolean execute(T data) {
        if (data == null) {
            this.logger.warn("execute(). data is null");
            return false;
        }
        if (!this.isRun.get()) {
            this.logger.warn("{} is shutdown. discard data:{}", (Object)this.executorName, data);
            return false;
        }
        boolean offer = this.queue.offer(data);
        if (!offer) {
            this.logger.warn("{} Drop data. queue is full. size:{}", (Object)this.executorName, (Object)this.queue.size());
        }
        return offer;
    }

    private void doAccept(Collection<T> elements) {
        try {
            this.consumer.acceptN(elements);
        }
        finally {
            elements.clear();
        }
    }

    private void doAccept(T element) {
        this.consumer.accept(element);
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public boolean isRun() {
        return this.isRun.get();
    }

    public void stop() {
        this.isRun.set(false);
        if (!this.isEmpty()) {
            this.logger.info("Wait 5 seconds. Flushing queued data.");
        }
        this.executeThread.interrupt();
        try {
            this.executeThread.join(5000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.warn("{} stopped incompletely.", (Object)this.executorName);
        }
        this.logger.info("{} stopped.", (Object)this.executorName);
    }

    Collection<T> getDrainQueue() {
        return this.drain;
    }
}

