/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.table.catalog;

import java.sql.JDBCType;
import java.util.List;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.table.catalog.ColumnEditor;
import org.apache.eventmesh.connector.jdbc.table.catalog.Options;
import org.apache.eventmesh.connector.jdbc.table.type.EventMeshDataType;

public abstract class AbstractColumnEditorImpl<CE extends ColumnEditor, Col extends Column>
implements ColumnEditor<CE, Col> {
    private String name;
    private EventMeshDataType<?> eventMeshDataType;
    private Long columnLength;
    private Integer scale;
    private boolean notNull;
    private String comment;
    private Object defaultValue;
    private String typeName;
    private JDBCType jdbcType;
    private String defaultValueExpression;
    private boolean optional;
    private int order;
    private String charsetName;
    private Boolean autoIncremented;
    private Boolean generated;
    private List<String> enumValues;
    private Options options;

    public AbstractColumnEditorImpl(String name) {
        this.name = name;
    }

    public AbstractColumnEditorImpl() {
    }

    @Override
    public CE withName(String name) {
        this.name = name;
        return (CE)this;
    }

    @Override
    public String ofName() {
        return this.name;
    }

    @Override
    public CE withType(String typeName) {
        this.typeName = typeName;
        return (CE)this;
    }

    @Override
    public CE withJdbcType(JDBCType jdbcType) {
        this.jdbcType = jdbcType;
        return (CE)this;
    }

    @Override
    public CE withEventMeshType(EventMeshDataType eventMeshType) {
        this.eventMeshDataType = eventMeshType;
        return (CE)this;
    }

    @Override
    public CE withOrder(int order) {
        this.order = order;
        return (CE)this;
    }

    @Override
    public CE length(long length) {
        this.columnLength = length;
        return (CE)this;
    }

    @Override
    public CE scale(Integer scale) {
        this.scale = scale;
        return (CE)this;
    }

    @Override
    public CE optional(boolean optional) {
        this.optional = optional;
        return (CE)this;
    }

    @Override
    public CE comment(String comment) {
        this.comment = comment;
        return (CE)this;
    }

    @Override
    public CE defaultValueExpression(String defaultValueExpression) {
        this.defaultValueExpression = defaultValueExpression;
        return (CE)this;
    }

    @Override
    public CE defaultValue(Object value) {
        this.defaultValue = value;
        return (CE)this;
    }

    @Override
    public CE notNull(boolean notNull) {
        this.notNull = notNull;
        return (CE)this;
    }

    @Override
    public CE charsetName(String charsetName) {
        this.charsetName = charsetName;
        return (CE)this;
    }

    @Override
    public CE enumValues(List<String> enumValues) {
        this.enumValues = enumValues;
        return (CE)this;
    }

    @Override
    public CE withOption(String key, Object value) {
        if (this.options == null) {
            this.options = new Options();
        }
        this.options.put(key, value);
        return (CE)this;
    }

    @Override
    public CE withOptions(Options options) {
        if (options != null) {
            if (this.options == null) {
                this.options = new Options();
            }
            this.options.putAll(options);
        }
        return (CE)this;
    }

    public EventMeshDataType ofEventMeshDataType() {
        return this.eventMeshDataType;
    }

    public Long ofColumnLength() {
        return this.columnLength;
    }

    public Integer ofScale() {
        return this.scale;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public String ofComment() {
        return this.comment;
    }

    public Object ofDefaultValue() {
        return this.defaultValue;
    }

    public String ofTypeName() {
        return this.typeName;
    }

    public JDBCType ofJdbcType() {
        return this.jdbcType;
    }

    public String ofDefaultValueExpression() {
        return this.defaultValueExpression;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public int ofOrder() {
        return this.order;
    }

    public String ofCharsetName() {
        return this.charsetName;
    }

    public List<String> ofEnumValues() {
        return this.enumValues;
    }

    public Options ofOptions() {
        return this.options;
    }
}

