/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source.dialect.cdc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.common.ThreadWrapper;
import org.apache.eventmesh.common.config.connector.SourceConfig;
import org.apache.eventmesh.common.config.connector.rdb.jdbc.JdbcSourceConfig;
import org.apache.eventmesh.common.config.connector.rdb.jdbc.SourceConnectorConfig;
import org.apache.eventmesh.connector.jdbc.JdbcContext;
import org.apache.eventmesh.connector.jdbc.ddl.DdlParser;
import org.apache.eventmesh.connector.jdbc.dialect.DatabaseDialect;
import org.apache.eventmesh.connector.jdbc.source.dialect.cdc.CdcEngine;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCdcEngine<Parse extends DdlParser, Ctx extends JdbcContext, DbDialect extends DatabaseDialect>
extends ThreadWrapper
implements CdcEngine<Ctx> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractCdcEngine.class);
    protected final JdbcSourceConfig jdbcSourceConfig;
    protected final DbDialect databaseDialect;
    protected final SourceConnectorConfig sourceConnectorConfig;
    private final Set<TableId> includeDatabaseTable = new HashSet<TableId>(64);

    public AbstractCdcEngine(SourceConfig config, DbDialect databaseDialect) {
        if (!(config instanceof JdbcSourceConfig)) {
            throw new IllegalArgumentException("config ");
        }
        this.jdbcSourceConfig = (JdbcSourceConfig)config;
        this.databaseDialect = databaseDialect;
        this.sourceConnectorConfig = this.jdbcSourceConfig.getSourceConnectorConfig();
        this.calculateNeedHandleTable();
    }

    @Override
    public Set<TableId> getHandledTables() {
        return this.includeDatabaseTable;
    }

    protected Set<TableId> calculateNeedHandleTable() {
        List tableExcludeList;
        List databaseExcludeList;
        Set<String> defaultExcludeDatabase;
        ArrayList<String> databaseIncludeList = this.sourceConnectorConfig.getDatabaseIncludeList();
        if (CollectionUtils.isEmpty((Collection)databaseIncludeList)) {
            List<String> allDatabases = this.databaseDialect.listDatabases();
            databaseIncludeList = new ArrayList<String>(allDatabases);
        }
        if (CollectionUtils.isNotEmpty(defaultExcludeDatabase = this.defaultExcludeDatabase())) {
            databaseIncludeList.removeAll(defaultExcludeDatabase);
        }
        if (CollectionUtils.isNotEmpty((Collection)(databaseExcludeList = this.sourceConnectorConfig.getDatabaseExcludeList()))) {
            databaseIncludeList.removeAll(databaseExcludeList);
        }
        List tableIncludeList = this.sourceConnectorConfig.getTableIncludeList();
        ArrayList<TableId> includeTableList = new ArrayList<TableId>();
        if (CollectionUtils.isNotEmpty((Collection)tableIncludeList)) {
            List<TableId> tableIdList = this.buildTableId(tableIncludeList);
            includeTableList.addAll(tableIdList);
        }
        if (CollectionUtils.isEmpty((Collection)tableIncludeList)) {
            for (String database : databaseIncludeList) {
                try {
                    List<TableId> tableIds = this.databaseDialect.listTables(database);
                    includeTableList.addAll(tableIds);
                }
                catch (SQLException e) {
                    log.warn("List database[{}] table error", (Object)database, (Object)e);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(tableExcludeList = this.sourceConnectorConfig.getTableExcludeList()))) {
            includeTableList.removeAll(this.buildTableId(tableExcludeList));
        }
        this.includeDatabaseTable.addAll(includeTableList);
        return this.includeDatabaseTable;
    }

    private List<TableId> buildTableId(List<String> tables) {
        return ((List)Optional.ofNullable(tables).orElse(new ArrayList(0))).stream().map(table -> {
            String[] split = table.split("\\.");
            return new TableId(split[0], null, split[1]);
        }).collect(Collectors.toList());
    }

    protected abstract Set<String> defaultExcludeDatabase();

    protected abstract Parse getDdlParser();
}

