/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source.dialect.antlr4.mysql.listener;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.connector.jdbc.antlr4.autogeneration.MySqlParser;
import org.apache.eventmesh.connector.jdbc.antlr4.autogeneration.MySqlParserBaseListener;
import org.apache.eventmesh.connector.jdbc.source.dialect.antlr4.mysql.MysqlAntlr4DdlParser;
import org.apache.eventmesh.connector.jdbc.source.dialect.antlr4.mysql.listener.DefaultValueParserListener;
import org.apache.eventmesh.connector.jdbc.source.dialect.mysql.MysqlDataTypeConvertor;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableEditor;
import org.apache.eventmesh.connector.jdbc.table.catalog.mysql.MysqlColumnEditor;
import org.apache.eventmesh.connector.jdbc.table.catalog.mysql.MysqlOptions;
import org.apache.eventmesh.connector.jdbc.table.type.EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.utils.JdbcStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnDefinitionParserListener
extends MySqlParserBaseListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ColumnDefinitionParserListener.class);
    private DefaultValueParserListener defaultValueParserListener;
    private final List<ParseTreeListener> listeners;
    private TableEditor tableEditor;
    private MysqlColumnEditor columnEditor;
    private final MysqlAntlr4DdlParser parser;
    private MysqlDataTypeConvertor dataTypeConvertor;
    private AtomicReference<Boolean> ignoreColumn = new AtomicReference<Boolean>(false);

    public ColumnDefinitionParserListener(List<ParseTreeListener> listeners, TableEditor tableEditor, MysqlColumnEditor columnEditor, MysqlAntlr4DdlParser parser) {
        this.listeners = listeners;
        this.tableEditor = tableEditor;
        this.columnEditor = columnEditor;
        this.parser = parser;
        this.dataTypeConvertor = new MysqlDataTypeConvertor();
    }

    @Override
    public void enterColumnDefinition(MySqlParser.ColumnDefinitionContext ctx) {
        this.parser.runIfAllNotNull(() -> {
            MySqlParser.CollectionDataTypeContext collectionDataTypeContext;
            String charsetName;
            MySqlParser.DataTypeContext dataTypeContext = ctx.dataType();
            String dataTypeString = null;
            if (dataTypeContext instanceof MySqlParser.StringDataTypeContext) {
                MySqlParser.StringDataTypeContext stringDataTypeCtx = (MySqlParser.StringDataTypeContext)dataTypeContext;
                dataTypeString = stringDataTypeCtx.typeName.getText();
                if (stringDataTypeCtx.lengthOneDimension() != null) {
                    this.columnEditor.length(Integer.parseInt(stringDataTypeCtx.lengthOneDimension().decimalLiteral().getText()));
                }
                charsetName = this.parser.parseCharset(stringDataTypeCtx.charsetName());
                String collationName = this.parser.parseCollation(stringDataTypeCtx.collationName());
                this.columnEditor.charsetName(charsetName);
                this.columnEditor.collation(collationName);
            } else if (dataTypeContext instanceof MySqlParser.NationalStringDataTypeContext) {
                MySqlParser.NationalStringDataTypeContext nationalStringDataTypeCtx = (MySqlParser.NationalStringDataTypeContext)dataTypeContext;
                dataTypeString = nationalStringDataTypeCtx.typeName.getText();
                if (nationalStringDataTypeCtx.lengthOneDimension() != null) {
                    this.columnEditor.length(Integer.parseInt(nationalStringDataTypeCtx.lengthOneDimension().decimalLiteral().getText()));
                }
            } else if (dataTypeContext instanceof MySqlParser.NationalVaryingStringDataTypeContext) {
                MySqlParser.NationalVaryingStringDataTypeContext nationalVaryingStringDataTypeCtx = (MySqlParser.NationalVaryingStringDataTypeContext)dataTypeContext;
                dataTypeString = nationalVaryingStringDataTypeCtx.typeName.getText();
                if (nationalVaryingStringDataTypeCtx.lengthOneDimension() != null) {
                    this.columnEditor.length(Integer.parseInt(nationalVaryingStringDataTypeCtx.lengthOneDimension().decimalLiteral().getText()));
                }
            } else if (dataTypeContext instanceof MySqlParser.DimensionDataTypeContext) {
                List<MySqlParser.DecimalLiteralContext> decimalLiteralContexts;
                MySqlParser.DimensionDataTypeContext dimensionDataTypeCtx = (MySqlParser.DimensionDataTypeContext)dataTypeContext;
                dataTypeString = dimensionDataTypeCtx.typeName.getText();
                if (dimensionDataTypeCtx.lengthOneDimension() != null) {
                    this.columnEditor.length(Integer.parseInt(dimensionDataTypeCtx.lengthOneDimension().decimalLiteral().getText()));
                }
                if (dimensionDataTypeCtx.lengthTwoDimension() != null) {
                    decimalLiteralContexts = dimensionDataTypeCtx.lengthTwoDimension().decimalLiteral();
                    this.columnEditor.length(Integer.parseInt(decimalLiteralContexts.get(0).getText()));
                    this.columnEditor.scale(Integer.parseInt(decimalLiteralContexts.get(1).getText()));
                }
                if (dimensionDataTypeCtx.lengthTwoOptionalDimension() != null) {
                    decimalLiteralContexts = dimensionDataTypeCtx.lengthTwoOptionalDimension().decimalLiteral();
                    if (decimalLiteralContexts.get(0).REAL_LITERAL() != null) {
                        String[] digits = decimalLiteralContexts.get(0).getText().split(".");
                        if (StringUtils.isBlank((CharSequence)digits[0]) || Integer.valueOf(digits[0]) == 0) {
                            this.columnEditor.length(10L);
                        } else {
                            this.columnEditor.length(Integer.valueOf(digits[0]).intValue());
                        }
                    } else {
                        this.columnEditor.length(Integer.parseInt(decimalLiteralContexts.get(0).getText()));
                    }
                    if (decimalLiteralContexts.size() > 1) {
                        this.columnEditor.scale(Integer.parseInt(decimalLiteralContexts.get(1).getText()));
                    }
                }
                if (CollectionUtils.isNotEmpty(dimensionDataTypeCtx.SIGNED())) {
                    this.columnEditor.withOption(MysqlOptions.MysqlColumnOptions.SIGNED, dimensionDataTypeCtx.SIGNED().get(0).getText());
                }
                if (CollectionUtils.isNotEmpty(dimensionDataTypeCtx.UNSIGNED())) {
                    this.columnEditor.withOption(MysqlOptions.MysqlColumnOptions.UNSIGNED, dimensionDataTypeCtx.UNSIGNED().get(0).getText());
                }
                if (CollectionUtils.isNotEmpty(dimensionDataTypeCtx.ZEROFILL())) {
                    this.columnEditor.withOption(MysqlOptions.MysqlColumnOptions.ZEROFILL, dimensionDataTypeCtx.ZEROFILL().get(0).getText());
                }
            } else if (dataTypeContext instanceof MySqlParser.SimpleDataTypeContext) {
                MySqlParser.SimpleDataTypeContext simpleDataTypeCtx = (MySqlParser.SimpleDataTypeContext)dataTypeContext;
                dataTypeString = simpleDataTypeCtx.typeName.getText();
            } else if (dataTypeContext instanceof MySqlParser.CollectionDataTypeContext) {
                collectionDataTypeContext = (MySqlParser.CollectionDataTypeContext)dataTypeContext;
                dataTypeString = collectionDataTypeContext.typeName.getText();
                if (collectionDataTypeContext.charsetName() != null) {
                    charsetName = collectionDataTypeContext.charsetName().getText();
                    this.columnEditor.charsetName(charsetName);
                }
            } else if (dataTypeContext instanceof MySqlParser.SpatialDataTypeContext) {
                MySqlParser.SpatialDataTypeContext spatialDataTypeCtx = (MySqlParser.SpatialDataTypeContext)dataTypeContext;
                dataTypeString = spatialDataTypeCtx.typeName.getText();
            } else if (dataTypeContext instanceof MySqlParser.LongVarcharDataTypeContext) {
                MySqlParser.LongVarcharDataTypeContext longVarcharDataTypeCtx = (MySqlParser.LongVarcharDataTypeContext)dataTypeContext;
                dataTypeString = longVarcharDataTypeCtx.typeName.getText();
                charsetName = this.parser.parseCharset(longVarcharDataTypeCtx.charsetName());
                String collationName = this.parser.parseCollation(longVarcharDataTypeCtx.collationName());
                this.columnEditor.charsetName(charsetName);
                this.columnEditor.collation(collationName);
            }
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)dataTypeString, (CharSequence[])new CharSequence[]{"ENUM", "SET"})) {
                collectionDataTypeContext = (MySqlParser.CollectionDataTypeContext)dataTypeContext;
                List<String> values = collectionDataTypeContext.collectionOptions().STRING_LITERAL().stream().map(node -> JdbcStringUtils.withoutWrapper(node.getText())).collect(Collectors.toList());
                this.columnEditor.enumValues(values);
            }
            if (StringUtils.isNotBlank((CharSequence)dataTypeString)) {
                EventMeshDataType<?> eventMeshType = this.dataTypeConvertor.toEventMeshType(dataTypeString);
                this.columnEditor.withEventMeshType(eventMeshType);
                this.columnEditor.withJdbcType(this.dataTypeConvertor.toJDBCType(dataTypeString));
                this.columnEditor.withType(dataTypeString);
            }
        }, this.columnEditor);
        this.parser.runIfAllNotNull(() -> {
            this.defaultValueParserListener = new DefaultValueParserListener(this.columnEditor);
            this.listeners.add(this.defaultValueParserListener);
        }, this.tableEditor, this.columnEditor);
        super.enterColumnDefinition(ctx);
    }

    @Override
    public void enterNullNotnull(MySqlParser.NullNotnullContext ctx) {
        this.columnEditor.notNull(ctx.NOT() != null);
        super.enterNullNotnull(ctx);
    }

    @Override
    public void enterAutoIncrementColumnConstraint(MySqlParser.AutoIncrementColumnConstraintContext ctx) {
        this.columnEditor.autoIncremented(true);
        this.columnEditor.generated(true);
        super.enterAutoIncrementColumnConstraint(ctx);
    }

    @Override
    public void enterCommentColumnConstraint(MySqlParser.CommentColumnConstraintContext ctx) {
        if (ctx.COMMENT() != null && ctx.STRING_LITERAL() != null) {
            this.columnEditor.comment(JdbcStringUtils.withoutWrapper(ctx.STRING_LITERAL().getText()));
        }
        super.enterCommentColumnConstraint(ctx);
    }

    @Override
    public void enterPrimaryKeyColumnConstraint(MySqlParser.PrimaryKeyColumnConstraintContext ctx) {
        this.ignoreColumn.set(false);
        this.tableEditor.withPrimaryKeyNames(this.columnEditor.ofName());
        super.enterPrimaryKeyColumnConstraint(ctx);
    }

    @Override
    public void enterUniqueKeyColumnConstraint(MySqlParser.UniqueKeyColumnConstraintContext ctx) {
        this.ignoreColumn.set(false);
        super.enterUniqueKeyColumnConstraint(ctx);
    }

    @Override
    public void exitColumnDefinition(MySqlParser.ColumnDefinitionContext ctx) {
        if (!this.ignoreColumn.get().booleanValue()) {
            this.ignoreColumn.set(false);
        }
        this.parser.runIfAllNotNull(() -> this.listeners.remove(this.defaultValueParserListener), this.tableEditor);
        super.exitColumnDefinition(ctx);
    }

    @Override
    public void enterCollateColumnConstraint(MySqlParser.CollateColumnConstraintContext ctx) {
        if (ctx.COLLATE() != null) {
            this.columnEditor.collation(ctx.collationName().getText());
        }
        super.enterCollateColumnConstraint(ctx);
    }

    @Generated
    public DefaultValueParserListener getDefaultValueParserListener() {
        return this.defaultValueParserListener;
    }

    @Generated
    public List<ParseTreeListener> getListeners() {
        return this.listeners;
    }

    @Generated
    public TableEditor getTableEditor() {
        return this.tableEditor;
    }

    @Generated
    public MysqlColumnEditor getColumnEditor() {
        return this.columnEditor;
    }

    @Generated
    public MysqlAntlr4DdlParser getParser() {
        return this.parser;
    }

    @Generated
    public MysqlDataTypeConvertor getDataTypeConvertor() {
        return this.dataTypeConvertor;
    }

    @Generated
    public AtomicReference<Boolean> getIgnoreColumn() {
        return this.ignoreColumn;
    }

    @Generated
    public void setDefaultValueParserListener(DefaultValueParserListener defaultValueParserListener) {
        this.defaultValueParserListener = defaultValueParserListener;
    }

    @Generated
    public void setTableEditor(TableEditor tableEditor) {
        this.tableEditor = tableEditor;
    }

    @Generated
    public void setColumnEditor(MysqlColumnEditor columnEditor) {
        this.columnEditor = columnEditor;
    }

    @Generated
    public void setDataTypeConvertor(MysqlDataTypeConvertor dataTypeConvertor) {
        this.dataTypeConvertor = dataTypeConvertor;
    }

    @Generated
    public void setIgnoreColumn(AtomicReference<Boolean> ignoreColumn) {
        this.ignoreColumn = ignoreColumn;
    }
}

