/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.acs.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.event.IEventHandler;
import com.lark.oapi.service.acs.v1.model.GetAccessRecordAccessPhotoReq;
import com.lark.oapi.service.acs.v1.model.GetAccessRecordAccessPhotoResp;
import com.lark.oapi.service.acs.v1.model.GetUserFaceReq;
import com.lark.oapi.service.acs.v1.model.GetUserFaceResp;
import com.lark.oapi.service.acs.v1.model.GetUserReq;
import com.lark.oapi.service.acs.v1.model.GetUserResp;
import com.lark.oapi.service.acs.v1.model.ListAccessRecordReq;
import com.lark.oapi.service.acs.v1.model.ListAccessRecordResp;
import com.lark.oapi.service.acs.v1.model.ListDeviceResp;
import com.lark.oapi.service.acs.v1.model.ListUserReq;
import com.lark.oapi.service.acs.v1.model.ListUserResp;
import com.lark.oapi.service.acs.v1.model.P2AccessRecordCreatedV1;
import com.lark.oapi.service.acs.v1.model.P2UserUpdatedV1;
import com.lark.oapi.service.acs.v1.model.PatchUserReq;
import com.lark.oapi.service.acs.v1.model.PatchUserResp;
import com.lark.oapi.service.acs.v1.model.UpdateUserFaceReq;
import com.lark.oapi.service.acs.v1.model.UpdateUserFaceResp;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcsService {
    private static final Logger log = LoggerFactory.getLogger(AcsService.class);
    private final AccessRecord accessRecord;
    private final AccessRecordAccessPhoto accessRecordAccessPhoto;
    private final Device device;
    private final User user;
    private final UserFace userFace;

    public AcsService(Config config) {
        this.accessRecord = new AccessRecord(config);
        this.accessRecordAccessPhoto = new AccessRecordAccessPhoto(config);
        this.device = new Device(config);
        this.user = new User(config);
        this.userFace = new UserFace(config);
    }

    public AccessRecord accessRecord() {
        return this.accessRecord;
    }

    public AccessRecordAccessPhoto accessRecordAccessPhoto() {
        return this.accessRecordAccessPhoto;
    }

    public Device device() {
        return this.device;
    }

    public User user() {
        return this.user;
    }

    public UserFace userFace() {
        return this.userFace;
    }

    public static abstract class P2UserUpdatedV1Handler
    implements IEventHandler<P2UserUpdatedV1> {
        @Override
        public P2UserUpdatedV1 getEvent() {
            return new P2UserUpdatedV1();
        }
    }

    public static abstract class P2AccessRecordCreatedV1Handler
    implements IEventHandler<P2AccessRecordCreatedV1> {
        @Override
        public P2AccessRecordCreatedV1 getEvent() {
            return new P2AccessRecordCreatedV1();
        }
    }

    public static class UserFace {
        private final Config config;

        public UserFace(Config config) {
            this.config = config;
        }

        public GetUserFaceResp get(GetUserFaceReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            reqOptions.setSupportDownLoad(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/acs/v1/users/:user_id/face", Sets.newHashSet(AccessTokenType.Tenant), req);
            if (httpResponse.getStatusCode() == 200) {
                GetUserFaceResp resp = new GetUserFaceResp();
                resp.setRawResponse(httpResponse);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                outputStream.write(httpResponse.getBody());
                resp.setData(outputStream);
                resp.setFileName(httpResponse.getFileName());
                return resp;
            }
            GetUserFaceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetUserFaceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/acs/v1/users/:user_id/face", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetUserFaceResp get(GetUserFaceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            reqOptions.setSupportDownLoad(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/acs/v1/users/:user_id/face", Sets.newHashSet(AccessTokenType.Tenant), req);
            if (httpResponse.getStatusCode() == 200) {
                GetUserFaceResp resp = new GetUserFaceResp();
                resp.setRawResponse(httpResponse);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                outputStream.write(httpResponse.getBody());
                resp.setData(outputStream);
                resp.setFileName(httpResponse.getFileName());
                return resp;
            }
            GetUserFaceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetUserFaceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/acs/v1/users/:user_id/face", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateUserFaceResp update(UpdateUserFaceReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            reqOptions.setSupportUpload(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/acs/v1/users/:user_id/face", Sets.newHashSet(AccessTokenType.Tenant), req);
            UpdateUserFaceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateUserFaceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/acs/v1/users/:user_id/face", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateUserFaceResp update(UpdateUserFaceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            reqOptions.setSupportUpload(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/acs/v1/users/:user_id/face", Sets.newHashSet(AccessTokenType.Tenant), req);
            UpdateUserFaceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateUserFaceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/acs/v1/users/:user_id/face", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class User {
        private final Config config;

        public User(Config config) {
            this.config = config;
        }

        public GetUserResp get(GetUserReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetUserResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/acs/v1/users/:user_id", Sets.newHashSet(AccessTokenType.Tenant), req), GetUserResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/acs/v1/users/:user_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetUserResp get(GetUserReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/acs/v1/users/:user_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetUserResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetUserResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/acs/v1/users/:user_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListUserResp list(ListUserReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListUserResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/acs/v1/users", Sets.newHashSet(AccessTokenType.Tenant), req), ListUserResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/acs/v1/users", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListUserResp list(ListUserReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/acs/v1/users", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListUserResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListUserResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/acs/v1/users", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchUserResp patch(PatchUserReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            PatchUserResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/acs/v1/users/:user_id", Sets.newHashSet(AccessTokenType.Tenant), req), PatchUserResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/acs/v1/users/:user_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PatchUserResp patch(PatchUserReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/acs/v1/users/:user_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            PatchUserResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchUserResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/acs/v1/users/:user_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Device {
        private final Config config;

        public Device(Config config) {
            this.config = config;
        }

        public ListDeviceResp list(RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListDeviceResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/acs/v1/devices", Sets.newHashSet(AccessTokenType.Tenant), null), ListDeviceResp.class)) == null) {
                log.error(String.format("%s,callError,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/acs/v1/devices", Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            return resp;
        }

        public ListDeviceResp list() throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/acs/v1/devices", Sets.newHashSet(AccessTokenType.Tenant), null);
            ListDeviceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListDeviceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/acs/v1/devices", Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            return resp;
        }
    }

    public static class AccessRecordAccessPhoto {
        private final Config config;

        public AccessRecordAccessPhoto(Config config) {
            this.config = config;
        }

        public GetAccessRecordAccessPhotoResp get(GetAccessRecordAccessPhotoReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            reqOptions.setSupportDownLoad(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/acs/v1/access_records/:access_record_id/access_photo", Sets.newHashSet(AccessTokenType.Tenant), req);
            if (httpResponse.getStatusCode() == 200) {
                GetAccessRecordAccessPhotoResp resp = new GetAccessRecordAccessPhotoResp();
                resp.setRawResponse(httpResponse);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                outputStream.write(httpResponse.getBody());
                resp.setData(outputStream);
                resp.setFileName(httpResponse.getFileName());
                return resp;
            }
            GetAccessRecordAccessPhotoResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetAccessRecordAccessPhotoResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/acs/v1/access_records/:access_record_id/access_photo", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetAccessRecordAccessPhotoResp get(GetAccessRecordAccessPhotoReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            reqOptions.setSupportDownLoad(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/acs/v1/access_records/:access_record_id/access_photo", Sets.newHashSet(AccessTokenType.Tenant), req);
            if (httpResponse.getStatusCode() == 200) {
                GetAccessRecordAccessPhotoResp resp = new GetAccessRecordAccessPhotoResp();
                resp.setRawResponse(httpResponse);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                outputStream.write(httpResponse.getBody());
                resp.setData(outputStream);
                resp.setFileName(httpResponse.getFileName());
                return resp;
            }
            GetAccessRecordAccessPhotoResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetAccessRecordAccessPhotoResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/acs/v1/access_records/:access_record_id/access_photo", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class AccessRecord {
        private final Config config;

        public AccessRecord(Config config) {
            this.config = config;
        }

        public ListAccessRecordResp list(ListAccessRecordReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListAccessRecordResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/acs/v1/access_records", Sets.newHashSet(AccessTokenType.Tenant), req), ListAccessRecordResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/acs/v1/access_records", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListAccessRecordResp list(ListAccessRecordReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/acs/v1/access_records", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListAccessRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListAccessRecordResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/acs/v1/access_records", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }
}

