/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.meta.zookeeper.service;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.retry.RetryForever;
import org.apache.curator.retry.RetryNTimes;
import org.apache.eventmesh.api.exception.MetaException;
import org.apache.eventmesh.api.meta.MetaService;
import org.apache.eventmesh.api.meta.MetaServiceListener;
import org.apache.eventmesh.api.meta.dto.EventMeshDataInfo;
import org.apache.eventmesh.api.meta.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.meta.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.config.ConfigService;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.meta.zookeeper.config.ZKRegistryConfiguration;
import org.apache.eventmesh.meta.zookeeper.pojo.EventMeshInstance;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperMetaService
implements MetaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZookeeperMetaService.class);
    private final AtomicBoolean initStatus = new AtomicBoolean(false);
    private final AtomicBoolean startStatus = new AtomicBoolean(false);
    private String serverAddr;
    private CuratorFramework zkClient;
    private ConcurrentMap<String, EventMeshRegisterInfo> eventMeshRegisterInfoMap;
    private ZKRegistryConfiguration zkConfig;

    public void init() throws MetaException {
        ZKRegistryConfiguration zkConfig;
        if (!this.initStatus.compareAndSet(false, true)) {
            log.warn("[ZookeeperRegistryService] has been init");
            return;
        }
        this.eventMeshRegisterInfoMap = new ConcurrentHashMap<String, EventMeshRegisterInfo>(ConfigurationContextUtil.KEYS.size());
        for (String key : ConfigurationContextUtil.KEYS) {
            CommonConfiguration commonConfiguration = ConfigurationContextUtil.get((String)key);
            if (commonConfiguration == null) continue;
            if (StringUtils.isBlank((CharSequence)commonConfiguration.getMetaStorageAddr())) {
                throw new MetaException("meta storage address cannot be null");
            }
            this.serverAddr = commonConfiguration.getMetaStorageAddr();
            break;
        }
        this.zkConfig = zkConfig = (ZKRegistryConfiguration)ConfigService.getInstance().buildConfigInstance(ZKRegistryConfiguration.class);
    }

    public void start() throws MetaException {
        if (!this.startStatus.compareAndSet(false, true)) {
            log.warn("[ZookeeperRegistryService] has been start");
            return;
        }
        try {
            this.zkClient = this.buildZkClient();
            this.zkClient.start();
        }
        catch (Exception e) {
            throw new MetaException("ZookeeperRegistry starting failed", (Throwable)e);
        }
    }

    private CuratorFramework buildZkClient() throws ClassNotFoundException {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(this.serverAddr).namespace("eventmesh");
        if (this.zkConfig == null) {
            builder.retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 5));
            return builder.build();
        }
        builder.retryPolicy(this.createRetryPolicy());
        String scheme = this.zkConfig.getScheme();
        String auth = this.zkConfig.getAuth();
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{scheme, auth})) {
            builder.authorization(scheme, auth.getBytes(Constants.DEFAULT_CHARSET));
        }
        Optional.ofNullable(this.zkConfig.getConnectionTimeoutMs()).ifPresent(timeout -> builder.connectionTimeoutMs(timeout.intValue()));
        Optional.ofNullable(this.zkConfig.getSessionTimeoutMs()).ifPresent(timeout -> builder.sessionTimeoutMs(timeout.intValue()));
        return builder.build();
    }

    private RetryPolicy createRetryPolicy() throws ClassNotFoundException {
        String retryPolicyClass = this.zkConfig.getRetryPolicyClass();
        if (StringUtils.isBlank((CharSequence)retryPolicyClass)) {
            return new ExponentialBackoffRetry(1000, 5);
        }
        Class<?> clazz = Class.forName(retryPolicyClass);
        if (clazz == ExponentialBackoffRetry.class) {
            return new ExponentialBackoffRetry(this.getOrDefault(this.zkConfig.getBaseSleepTimeMs(), 1000, Integer.class).intValue(), this.getOrDefault(this.zkConfig.getMaxRetries(), 5, Integer.class).intValue());
        }
        if (clazz == BoundedExponentialBackoffRetry.class) {
            return new BoundedExponentialBackoffRetry(this.getOrDefault(this.zkConfig.getBaseSleepTimeMs(), 1000, Integer.class).intValue(), this.getOrDefault(this.zkConfig.getMaxSleepTimeMs(), 5000, Integer.class).intValue(), this.getOrDefault(this.zkConfig.getMaxRetries(), 5, Integer.class).intValue());
        }
        if (clazz == RetryForever.class) {
            return new RetryForever(this.getOrDefault(this.zkConfig.getRetryIntervalTimeMs(), 1000, Integer.class).intValue());
        }
        if (clazz == RetryNTimes.class) {
            return new RetryNTimes(this.getOrDefault(this.zkConfig.getRetryNTimes(), 10, Integer.class).intValue(), this.getOrDefault(this.zkConfig.getSleepMsBetweenRetries(), 1000, Integer.class).intValue());
        }
        throw new IllegalArgumentException("Unsupported retry policy: " + retryPolicyClass);
    }

    private <T> T getOrDefault(T value, T defaultValue, Class<T> clazz) {
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public void shutdown() throws MetaException {
        if (!this.initStatus.compareAndSet(true, false)) {
            return;
        }
        if (!this.startStatus.compareAndSet(true, false)) {
            return;
        }
        if (this.zkClient != null) {
            this.zkClient.close();
        }
        log.info("ZookeeperRegistryService closed");
    }

    public List<EventMeshDataInfo> findEventMeshInfoByCluster(String clusterName) throws MetaException {
        ArrayList<EventMeshDataInfo> eventMeshDataInfoList = new ArrayList<EventMeshDataInfo>();
        for (String key : ConfigurationContextUtil.KEYS) {
            CommonConfiguration configuration = ConfigurationContextUtil.get((String)key);
            if (Objects.isNull(configuration)) continue;
            String eventMeshName = configuration.getEventMeshName();
            String serviceName = eventMeshName.concat("-").concat(key);
            this.findEventMeshInfo("findEventMeshInfoByCluster", clusterName, serviceName, eventMeshDataInfoList);
        }
        return eventMeshDataInfoList;
    }

    public List<EventMeshDataInfo> findAllEventMeshInfo() throws MetaException {
        ArrayList<EventMeshDataInfo> eventMeshDataInfoList = new ArrayList<EventMeshDataInfo>();
        for (Map.Entry entry : this.eventMeshRegisterInfoMap.entrySet()) {
            String serviceName = (String)entry.getKey();
            String clusterName = ((EventMeshRegisterInfo)entry.getValue()).getEventMeshClusterName();
            this.findEventMeshInfo("findAllEventMeshInfo", clusterName, serviceName, eventMeshDataInfoList);
        }
        return eventMeshDataInfoList;
    }

    private void findEventMeshInfo(String tipTitle, String clusterName, String serviceName, List<EventMeshDataInfo> eventMeshDataInfoList) throws MetaException {
        try {
            String servicePath = this.formatServicePath(clusterName, serviceName);
            List instances = (List)this.zkClient.getChildren().forPath(servicePath);
            if (CollectionUtils.isEmpty((Collection)instances)) {
                return;
            }
            for (String endpoint : instances) {
                byte[] data;
                String instancePath = servicePath.concat("/").concat(endpoint);
                Stat stat = new Stat();
                try {
                    data = (byte[])((WatchPathable)this.zkClient.getData().storingStatIn(stat)).forPath(instancePath);
                }
                catch (Exception e) {
                    log.warn("[ZookeeperRegistryService][{}] failed for path: {}", new Object[]{tipTitle, instancePath, e});
                    continue;
                }
                EventMeshInstance eventMeshInstance = (EventMeshInstance)JsonUtils.parseObject((String)new String(data, StandardCharsets.UTF_8), EventMeshInstance.class);
                EventMeshDataInfo eventMeshDataInfo = new EventMeshDataInfo(clusterName, serviceName, endpoint, stat.getMtime(), Objects.requireNonNull(eventMeshInstance, "instance must not be Null").getMetaData());
                eventMeshDataInfoList.add(eventMeshDataInfo);
            }
        }
        catch (Exception e) {
            throw new MetaException(String.format("ZookeeperRegistry {0} failed", tipTitle), (Throwable)e);
        }
    }

    public void registerMetadata(Map<String, String> metadataMap) {
        for (Map.Entry eventMeshRegisterInfo : this.eventMeshRegisterInfoMap.entrySet()) {
            EventMeshRegisterInfo registerInfo = (EventMeshRegisterInfo)eventMeshRegisterInfo.getValue();
            registerInfo.setMetadata(metadataMap);
            this.register(registerInfo);
        }
    }

    public Map<String, String> getMetaData(String key, boolean fuzzyEnabled) {
        return new HashMap<String, String>();
    }

    public void getMetaDataWithListener(MetaServiceListener metaServiceListener, String key) {
    }

    public void updateMetaData(Map<String, String> metadataMap) {
    }

    public void removeMetaData(String key) {
    }

    public boolean register(EventMeshRegisterInfo eventMeshRegisterInfo) throws MetaException {
        try {
            String[] ipPort = eventMeshRegisterInfo.getEndPoint().split(":");
            if (ipPort == null || ipPort.length < 2) {
                return false;
            }
            String ip = ipPort[0];
            int port = Integer.parseInt(ipPort[1]);
            String eventMeshName = eventMeshRegisterInfo.getEventMeshName();
            String eventMeshClusterName = eventMeshRegisterInfo.getEventMeshClusterName();
            Map instanceNumMap = eventMeshRegisterInfo.getEventMeshInstanceNumMap();
            Map metadata = eventMeshRegisterInfo.getMetadata();
            EventMeshInstance eventMeshInstance = new EventMeshInstance();
            eventMeshInstance.setIp(ip);
            eventMeshInstance.setPort(port);
            eventMeshInstance.setInstanceNumMap(instanceNumMap);
            eventMeshInstance.setMetaData(metadata);
            String path = this.formatInstancePath(eventMeshClusterName, eventMeshName, eventMeshRegisterInfo.getEndPoint());
            ((ACLBackgroundPathAndBytesable)this.zkClient.create().orSetData().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(path, Objects.requireNonNull(JsonUtils.toJSONString((Object)eventMeshInstance), "instance must not be Null").getBytes(StandardCharsets.UTF_8));
            this.eventMeshRegisterInfoMap.put(eventMeshName, eventMeshRegisterInfo);
        }
        catch (Exception e) {
            throw new MetaException("ZookeeperRegistry register failed", (Throwable)e);
        }
        log.info("EventMesh successfully registered to zookeeper");
        return true;
    }

    public boolean unRegister(EventMeshUnRegisterInfo eventMeshUnRegisterInfo) throws MetaException {
        try {
            String eventMeshName = eventMeshUnRegisterInfo.getEventMeshName();
            String eventMeshClusterName = eventMeshUnRegisterInfo.getEventMeshClusterName();
            String path = this.formatInstancePath(eventMeshClusterName, eventMeshName, eventMeshUnRegisterInfo.getEndPoint());
            this.zkClient.delete().forPath(path);
        }
        catch (Exception e) {
            throw new MetaException("ZookeeperRegistry unRegister failed", (Throwable)e);
        }
        log.info("EventMesh successfully logout to zookeeper");
        return true;
    }

    private String formatInstancePath(String clusterName, String serviceName, String endPoint) {
        return "/".concat(clusterName).concat("/").concat(serviceName).concat("/").concat(endPoint);
    }

    private String formatServicePath(String clusterName, String serviceName) {
        return "/".concat(clusterName).concat("/").concat(serviceName);
    }

    @Generated
    public String getServerAddr() {
        return this.serverAddr;
    }

    @Generated
    public CuratorFramework getZkClient() {
        return this.zkClient;
    }
}

