/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.push;

import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventUtils;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.StreamTopicConfig;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.AbstractPushRequest;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.HandleMsgContext;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamPushRequest
extends AbstractPushRequest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamPushRequest.class);
    private final Map<String, List<EventEmitter<CloudEvent>>> idcEmitters;
    private final List<EventEmitter<CloudEvent>> totalEmitters;
    private final SubscriptionMode subscriptionMode;
    private final int startIdx;

    public StreamPushRequest(HandleMsgContext handleMsgContext, Map<String, Set<AbstractPushRequest>> waitingRequests) {
        super(handleMsgContext, waitingRequests);
        StreamTopicConfig topicConfig = (StreamTopicConfig)handleMsgContext.getConsumeTopicConfig();
        this.idcEmitters = topicConfig.getIdcEmitters();
        this.totalEmitters = topicConfig.getTotalEmitters();
        this.subscriptionMode = topicConfig.getSubscriptionMode();
        this.startIdx = RandomUtils.nextInt((int)0, (int)this.totalEmitters.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryPushRequest() {
        if (this.eventMeshCloudEvent == null) {
            return;
        }
        List<EventEmitter<CloudEvent>> eventEmitters = this.selectEmitter();
        for (EventEmitter<CloudEvent> eventEmitter : eventEmitters) {
            long cost;
            this.lastPushTime = System.currentTimeMillis();
            this.eventMeshCloudEvent = CloudEvent.newBuilder((CloudEvent)this.eventMeshCloudEvent).putAttributes("reqeventmesh2ctimestamp", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(String.valueOf(this.lastPushTime)).build()).build();
            try {
                StreamObserver<CloudEvent> emitter;
                StreamObserver<CloudEvent> streamObserver = emitter = eventEmitter.getEmitter();
                synchronized (streamObserver) {
                    emitter.onNext((Object)this.eventMeshCloudEvent);
                }
                cost = System.currentTimeMillis() - this.lastPushTime;
                log.info("message|eventMesh2client|emitter|topic={}|bizSeqNo={}|uniqueId={}|cost={}", new Object[]{EventMeshCloudEventUtils.getSubject((CloudEvent)this.eventMeshCloudEvent), EventMeshCloudEventUtils.getSeqNum((CloudEvent)this.eventMeshCloudEvent), EventMeshCloudEventUtils.getUniqueId((CloudEvent)this.eventMeshCloudEvent), cost});
                this.complete();
            }
            catch (Throwable t) {
                cost = System.currentTimeMillis() - this.lastPushTime;
                log.error("message|eventMesh2client|exception={} |emitter|topic={}|bizSeqNo={}|uniqueId={}|cost={}", new Object[]{t.getMessage(), EventMeshCloudEventUtils.getSubject((CloudEvent)this.eventMeshCloudEvent), EventMeshCloudEventUtils.getSeqNum((CloudEvent)this.eventMeshCloudEvent), EventMeshCloudEventUtils.getUniqueId((CloudEvent)this.eventMeshCloudEvent), cost, t});
                this.delayRetry();
            }
        }
    }

    private List<EventEmitter<CloudEvent>> selectEmitter() {
        List emitterList = (List)MapUtils.getObject(this.idcEmitters, (Object)this.eventMeshGrpcConfiguration.getEventMeshIDC(), null);
        if (CollectionUtils.isNotEmpty((Collection)emitterList)) {
            return this.getEventEmitters(emitterList);
        }
        if (CollectionUtils.isNotEmpty(this.totalEmitters)) {
            return this.getEventEmitters(this.totalEmitters);
        }
        log.error("No event emitters from subscriber, no message returning.");
        return Collections.emptyList();
    }

    private List<EventEmitter<CloudEvent>> getEventEmitters(List<EventEmitter<CloudEvent>> emitterList) {
        switch (this.subscriptionMode) {
            case CLUSTERING: {
                return Collections.singletonList(emitterList.get((this.startIdx + this.retryTimes) % emitterList.size()));
            }
            case BROADCASTING: {
                return emitterList;
            }
        }
        log.error("Invalid Subscription Mode, no message returning back to subscriber.");
        return Collections.emptyList();
    }
}

