/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import io.cloudevents.CloudEvent;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpRequest;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.eventmesh.runtime.util.TraceUtils;
import org.apache.eventmesh.runtime.util.Utils;

public class HTTPTrace {
    public final boolean useTrace;

    public HTTPTrace(boolean useTrace) {
        this.useTrace = useTrace;
    }

    public TraceOperation getTraceOperation(HttpRequest httpRequest, Channel channel, boolean traceEnabled) {
        Map<String, Object> headerMap = Utils.parseHttpHeader(httpRequest);
        Span span = TraceUtils.prepareServerSpan(headerMap, "upstream-eventmesh-server-span", false);
        return new TraceOperation(span, null, traceEnabled);
    }

    public class TraceOperation {
        private final Span span;
        private TraceOperation childTraceOperation;
        private final boolean traceEnabled;

        public void endTrace(CloudEvent ce) {
            if (!HTTPTrace.this.useTrace) {
                return;
            }
            if (this.childTraceOperation != null) {
                this.childTraceOperation.endTrace(ce);
            }
            try (Scope ignored = this.span.makeCurrent();){
                TraceUtils.finishSpan(this.span, ce);
            }
        }

        public void exceptionTrace(@Nullable Throwable ex, Map<String, Object> map) {
            if (!HTTPTrace.this.useTrace) {
                return;
            }
            if (this.childTraceOperation != null) {
                this.childTraceOperation.exceptionTrace(ex, map);
            }
            try (Scope ignored = this.span.makeCurrent();){
                TraceUtils.finishSpanWithException(this.span, map, Objects.requireNonNull(ex).getMessage(), ex);
            }
        }

        public void endLatestTrace(CloudEvent ce) {
            if (this.childTraceOperation != null) {
                TraceOperation traceOperation = this.childTraceOperation.getChildTraceOperation();
                this.childTraceOperation.setChildTraceOperation(null);
                this.childTraceOperation.endTrace(ce);
                this.childTraceOperation = traceOperation;
            }
        }

        public void exceptionLatestTrace(@Nullable Throwable ex, Map<String, Object> traceMap) {
            if (this.childTraceOperation != null) {
                TraceOperation traceOperation = this.childTraceOperation.getChildTraceOperation();
                this.childTraceOperation.setChildTraceOperation(null);
                this.childTraceOperation.exceptionTrace(ex, traceMap);
                this.childTraceOperation = traceOperation;
            }
        }

        public TraceOperation createClientTraceOperation(Map<String, Object> map, String spanName, boolean isSpanFinishInOtherThread) {
            TraceOperation traceOperation = new TraceOperation(TraceUtils.prepareClientSpan(map, spanName, isSpanFinishInOtherThread), null, this.traceEnabled);
            this.setChildTraceOperation(traceOperation);
            return traceOperation;
        }

        public void setChildTraceOperation(TraceOperation traceOperation) {
            if (this.childTraceOperation != null) {
                this.childTraceOperation.setChildTraceOperation(traceOperation);
            }
            this.childTraceOperation = traceOperation;
        }

        @Generated
        public TraceOperation(Span span, TraceOperation childTraceOperation, boolean traceEnabled) {
            this.span = span;
            this.childTraceOperation = childTraceOperation;
            this.traceEnabled = traceEnabled;
        }

        @Generated
        public Span getSpan() {
            return this.span;
        }

        @Generated
        public TraceOperation getChildTraceOperation() {
            return this.childTraceOperation;
        }

        @Generated
        public boolean isTraceEnabled() {
            return this.traceEnabled;
        }
    }
}

