/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler.v1;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.utils.NetUtils;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.EventMeshHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcp2Client;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshHttpHandler(path="/clientManage/rejectClientBySubSystem")
public class RejectClientBySubSystemHandler
extends AbstractHttpHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RejectClientBySubSystemHandler.class);
    private final transient EventMeshTCPServer eventMeshTCPServer;

    public RejectClientBySubSystemHandler(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    private String printClients(Collection<InetSocketAddress> clients) {
        if (clients == null || clients.isEmpty()) {
            return "no session had been closed";
        }
        StringBuilder sb = new StringBuilder();
        for (InetSocketAddress addr : clients) {
            sb.append(addr).append("|");
        }
        return sb.toString();
    }

    @Override
    public void handle(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        String queryString = URI.create(httpRequest.uri()).getQuery();
        Map queryStringInfo = NetUtils.formData2Dic((String)queryString);
        String subSystem = (String)queryStringInfo.get("subsystem");
        if (StringUtils.isBlank((CharSequence)subSystem)) {
            String result = "params illegal!";
            this.writeText(ctx, result);
            return;
        }
        log.info("rejectClientBySubSystem in admin,subsys:{}====================", (Object)subSystem);
        ClientSessionGroupMapping clientSessionGroupMapping = this.eventMeshTCPServer.getClientSessionGroupMapping();
        ConcurrentHashMap<InetSocketAddress, Session> sessionMap = clientSessionGroupMapping.getSessionMap();
        ArrayList<InetSocketAddress> successRemoteAddrs = new ArrayList<InetSocketAddress>();
        try {
            if (!sessionMap.isEmpty()) {
                for (Session session : sessionMap.values()) {
                    InetSocketAddress addr;
                    if (!session.getClient().getSubsystem().equals(subSystem) || (addr = EventMeshTcp2Client.serverGoodby2Client(this.eventMeshTCPServer.getTcpThreadPoolGroup(), session, clientSessionGroupMapping)) == null) continue;
                    successRemoteAddrs.add(addr);
                }
            }
        }
        catch (Exception e) {
            log.error("clientManage|rejectClientBySubSystem|fail|subSystemId={}", (Object)subSystem, (Object)e);
            String result = String.format("rejectClientBySubSystem fail! sessionMap size {%d}, had reject {%s} , {subSystemId=%s}, errorMsg : %s", sessionMap.size(), this.printClients(successRemoteAddrs), subSystem, e.getMessage());
            this.writeText(ctx, result);
            return;
        }
        String result = String.format("rejectClientBySubSystem success! sessionMap size {%d}, had reject {%s} , {subSystemId=%s}", sessionMap.size(), this.printClients(successRemoteAddrs), subSystem);
        this.writeText(ctx, result);
    }
}

