/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class StringMapDataDecoder
implements MultiDecoder<Map<String, String>> {
    private final Decoder decoder = new Decoder(){

        public Object decode(ByteBuf buf, State state) throws IOException {
            String value = buf.toString(CharsetUtil.UTF_8);
            HashMap<String, String> result = new HashMap<String, String>();
            for (String entry : value.split("\r\n|\n")) {
                String[] parts = entry.split(":");
                if (parts.length != 2) continue;
                result.put(parts[0], parts[1]);
            }
            return result;
        }
    };

    @Override
    public Decoder<Object> getDecoder(Codec codec, int paramNum, State state, long size) {
        return this.decoder;
    }

    @Override
    public Map<String, String> decode(List<Object> parts, State state) {
        return null;
    }
}

