/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.util;

import com.navercorp.pinpoint.bootstrap.instrument.InterceptorScopeDefinition;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.AttachmentFactory;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.profiler.interceptor.scope.DefaultInterceptorScopeInvocation;
import com.navercorp.pinpoint.profiler.util.NamedThreadLocal;
import java.util.Objects;

public class ThreadLocalScope
implements InterceptorScopeInvocation {
    private final NamedThreadLocal<InterceptorScopeInvocation> scope;

    public ThreadLocalScope(final InterceptorScopeDefinition scopeDefinition) {
        Objects.requireNonNull(scopeDefinition, "scopeDefinition");
        this.scope = new NamedThreadLocal<InterceptorScopeInvocation>(scopeDefinition.getName()){

            @Override
            protected InterceptorScopeInvocation initialValue() {
                return new DefaultInterceptorScopeInvocation(scopeDefinition.getName());
            }
        };
    }

    public void leave(ExecutionPolicy policy) {
        InterceptorScopeInvocation localScope = this.getLocalScope();
        localScope.leave(policy);
    }

    public boolean tryEnter(ExecutionPolicy policy) {
        InterceptorScopeInvocation localScope = this.getLocalScope();
        return localScope.tryEnter(policy);
    }

    public boolean canLeave(ExecutionPolicy policy) {
        InterceptorScopeInvocation localScope = this.getLocalScope();
        return localScope.canLeave(policy);
    }

    protected InterceptorScopeInvocation getLocalScope() {
        return (InterceptorScopeInvocation)this.scope.get();
    }

    public String getName() {
        return this.scope.getName();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ThreadLocalScope{");
        sb.append("scope=").append(this.scope.getName());
        sb.append('}');
        return sb.toString();
    }

    public boolean isActive() {
        InterceptorScopeInvocation localScope = this.getLocalScope();
        return localScope.isActive();
    }

    public Object setAttachment(Object attachment) {
        InterceptorScopeInvocation localScope = this.getLocalScope();
        return localScope.setAttachment(attachment);
    }

    public Object getAttachment() {
        InterceptorScopeInvocation localScope = this.getLocalScope();
        return localScope.getAttachment();
    }

    public Object getOrCreateAttachment(AttachmentFactory factory) {
        InterceptorScopeInvocation localScope = this.getLocalScope();
        return localScope.getOrCreateAttachment(factory);
    }

    public Object removeAttachment() {
        InterceptorScopeInvocation localScope = this.getLocalScope();
        return localScope.removeAttachment();
    }
}

