/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc;

import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.grpc.MessageFormatUtils;
import com.navercorp.pinpoint.grpc.StatusError;
import com.navercorp.pinpoint.grpc.StatusErrors;
import com.navercorp.pinpoint.grpc.trace.AgentGrpc;
import com.navercorp.pinpoint.grpc.trace.PPing;
import com.navercorp.pinpoint.profiler.sender.grpc.Reconnector;
import com.navercorp.pinpoint.profiler.sender.grpc.StreamId;
import com.navercorp.pinpoint.profiler.sender.grpc.StreamUtils;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PingStreamContext {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final StreamId streamId;
    private final StreamObserver<PPing> requestObserver;
    private final PingClientResponseObserver responseObserver;
    private final Reconnector reconnector;
    private final ScheduledExecutorService retransmissionExecutor;

    public PingStreamContext(AgentGrpc.AgentStub agentStub, Reconnector reconnector, ScheduledExecutorService retransmissionExecutor) {
        Objects.requireNonNull(agentStub, "agentStub");
        this.streamId = StreamId.newStreamId("PingStream");
        this.reconnector = Objects.requireNonNull(reconnector, "reconnector");
        this.retransmissionExecutor = Objects.requireNonNull(retransmissionExecutor, "retransmissionExecutor");
        this.responseObserver = new PingClientResponseObserver();
        this.requestObserver = agentStub.pingSession((StreamObserver)this.responseObserver);
    }

    private PPing newPing() {
        PPing.Builder builder = PPing.newBuilder();
        return builder.build();
    }

    private ScheduledFuture<?> schedule(Runnable command) {
        try {
            return this.retransmissionExecutor.scheduleAtFixedRate(command, 0L, 1L, TimeUnit.MINUTES);
        }
        catch (RejectedExecutionException e) {
            this.logger.info("Ping scheduling failed");
            return null;
        }
    }

    public void close() {
        this.logger.info("{} close()", (Object)this.streamId);
        StreamUtils.close(this.requestObserver, this.logger);
    }

    public String toString() {
        return "PingStreamContext{" + this.streamId + '}';
    }

    private class PingClientResponseObserver
    implements ClientResponseObserver<PPing, PPing> {
        private volatile ScheduledFuture<?> pingScheduler;

        private PingClientResponseObserver() {
        }

        public void onNext(PPing ping) {
            PingStreamContext.this.logger.info("{} success:{}", (Object)PingStreamContext.this.streamId, (Object)MessageFormatUtils.debugLog((GeneratedMessageV3)ping));
        }

        public void onError(Throwable t) {
            StatusError statusError = StatusErrors.throwable((Throwable)t);
            if (statusError.isSimpleError()) {
                PingStreamContext.this.logger.info("Failed to ping stream, streamId={}, cause={}", (Object)PingStreamContext.this.streamId, (Object)statusError.getMessage());
            } else {
                PingStreamContext.this.logger.info("Failed to ping stream, streamId={}, cause={}", (Object)PingStreamContext.this.streamId, (Object)statusError.getMessage(), (Object)statusError.getThrowable());
            }
            this.cancelPingScheduler();
            PingStreamContext.this.reconnector.reconnect();
        }

        public void onCompleted() {
            PingStreamContext.this.logger.info("{} completed", (Object)PingStreamContext.this.streamId);
            this.cancelPingScheduler();
            PingStreamContext.this.reconnector.reconnect();
        }

        private void cancelPingScheduler() {
            ScheduledFuture<?> pingScheduler = this.pingScheduler;
            if (pingScheduler != null) {
                pingScheduler.cancel(false);
            } else {
                PingStreamContext.this.logger.info("pingScheduler is NULL");
            }
        }

        public void beforeStart(final ClientCallStreamObserver<PPing> requestStream) {
            requestStream.setOnReadyHandler(new Runnable(){

                @Override
                public void run() {
                    PingStreamContext.this.logger.info("{} onReady", (Object)PingStreamContext.this.streamId);
                    PingStreamContext.this.reconnector.reset();
                    Runnable pingRunnable = new Runnable(){

                        @Override
                        public void run() {
                            PPing pPing = PingStreamContext.this.newPing();
                            requestStream.onNext((Object)pPing);
                        }
                    };
                    PingClientResponseObserver.this.pingScheduler = PingStreamContext.this.schedule(pingRunnable);
                }
            });
        }
    }
}

