/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.collector.deadlock;

import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.metric.deadlock.DeadlockMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.deadlock.DeadlockMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.deadlock.ThreadDumpMetricSnapshot;
import com.navercorp.pinpoint.profiler.util.ThreadDumpUtils;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class DefaultDeadlockMetricCollector
implements AgentStatMetricCollector<DeadlockMetricSnapshot> {
    private Set<Long> prevDeadlockedThreadIdSet = new HashSet<Long>();
    private final DeadlockMetric deadlockMetric;

    public DefaultDeadlockMetricCollector(DeadlockMetric deadlockMetric) {
        this.deadlockMetric = Objects.requireNonNull(deadlockMetric, "deadlockMetric");
    }

    @Override
    public DeadlockMetricSnapshot collect() {
        Set<Long> deadlockedThreadIdSet = this.deadlockMetric.deadlockedThreadsIdSet();
        if (CollectionUtils.isEmpty(deadlockedThreadIdSet)) {
            return null;
        }
        if (this.prevDeadlockedThreadIdSet.containsAll(deadlockedThreadIdSet)) {
            DeadlockMetricSnapshot deadlock = new DeadlockMetricSnapshot();
            deadlock.setDeadlockedThreadCount(deadlockedThreadIdSet.size());
            return deadlock;
        }
        DeadlockMetricSnapshot deadlockMetricSnapshot = new DeadlockMetricSnapshot();
        deadlockMetricSnapshot.setDeadlockedThreadCount(deadlockedThreadIdSet.size());
        for (Long deadlockedThreadId : deadlockedThreadIdSet) {
            ThreadDumpMetricSnapshot tThreadDump = ThreadDumpUtils.createTThreadDump(deadlockedThreadId);
            deadlockMetricSnapshot.addDeadlockedThread(tThreadDump);
            this.prevDeadlockedThreadIdSet = deadlockedThreadIdSet;
        }
        return deadlockMetricSnapshot;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultDeadlockMetricCollector{");
        sb.append("prevDeadlockedThreadIdSet=").append(this.prevDeadlockedThreadIdSet);
        sb.append(", deadlockMetric=").append(this.deadlockMetric);
        sb.append('}');
        return sb.toString();
    }
}

