/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.metadata;

import com.navercorp.pinpoint.common.profiler.message.EnhancedDataSender;
import com.navercorp.pinpoint.io.ResponseMessage;
import com.navercorp.pinpoint.profiler.cache.Result;
import com.navercorp.pinpoint.profiler.cache.SimpleCache;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import com.navercorp.pinpoint.profiler.metadata.StringMetaData;
import com.navercorp.pinpoint.profiler.metadata.StringMetaDataService;
import java.util.Objects;

public class DefaultStringMetaDataService
implements StringMetaDataService {
    private final SimpleCache<String> stringCache;
    private final EnhancedDataSender<MetaDataType, ResponseMessage> enhancedDataSender;

    public DefaultStringMetaDataService(EnhancedDataSender<MetaDataType, ResponseMessage> enhancedDataSender, SimpleCache<String> stringCache) {
        this.enhancedDataSender = Objects.requireNonNull(enhancedDataSender, "enhancedDataSender");
        this.stringCache = Objects.requireNonNull(stringCache, "stringCache");
    }

    @Override
    public int cacheString(String value) {
        if (value == null) {
            return 0;
        }
        Object result = this.stringCache.put((Object)value);
        if (((Result)result).isNewValue()) {
            StringMetaData stringMetaData = new StringMetaData((Integer)((Result)result).getId(), value);
            this.enhancedDataSender.request((Object)stringMetaData);
        }
        return (Integer)((Result)result).getId();
    }
}

