/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.interceptor;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.profiler.instrument.interceptor.CodeBuilder;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorDefinition;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorType;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InvokeCodeGenerator;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaDataService;
import java.lang.reflect.Method;

public class InvokeAfterCodeGenerator
extends InvokeCodeGenerator {
    private static final int THIS_RETURN_EXCEPTION_SIZE = 3;
    private final int interceptorId;
    private final InterceptorDefinition interceptorDefinition;
    private final InstrumentClass targetClass;
    private final boolean localVarsInitialized;
    private final boolean catchClause;

    public InvokeAfterCodeGenerator(int interceptorId, InterceptorDefinition interceptorDefinition, InstrumentClass targetClass, InstrumentMethod targetMethod, ApiMetaDataService apiMetaDataService, boolean localVarsInitialized, boolean catchClause) {
        super(interceptorId, interceptorDefinition, targetMethod, apiMetaDataService);
        this.interceptorDefinition = interceptorDefinition;
        this.interceptorId = interceptorId;
        this.targetClass = targetClass;
        this.localVarsInitialized = localVarsInitialized;
        this.catchClause = catchClause;
    }

    public String generate() {
        Method afterMethod;
        CodeBuilder builder = new CodeBuilder();
        builder.begin();
        if (!this.localVarsInitialized) {
            builder.format("%1$s = %2$s.getInterceptor(%3$d); ", this.getInterceptorVar(), this.getInterceptorRegistryClassName(), this.interceptorId);
        }
        if ((afterMethod = this.interceptorDefinition.getAfterMethod()) != null) {
            builder.format("((%1$s)%2$s).after(", this.getInterceptorType(), this.getInterceptorVar());
            this.appendArguments(builder);
            builder.format(");", new Object[0]);
        }
        if (this.catchClause) {
            builder.append(" throw $e;");
        }
        builder.end();
        return builder.toString();
    }

    private String getReturnValue() {
        if (this.catchClause) {
            return "null";
        }
        if (!this.targetMethod.isConstructor() && "void".equals(this.targetMethod.getReturnType())) {
            return "null";
        }
        return "($w)$_";
    }

    private String getException() {
        if (this.catchClause) {
            return "$e";
        }
        return "null";
    }

    private void appendArguments(CodeBuilder builder) {
        InterceptorType type = this.interceptorDefinition.getInterceptorType();
        switch (type) {
            case ARRAY_ARGS: {
                this.appendSimpleAfterArguments(builder);
                break;
            }
            case STATIC: {
                this.appendStaticAfterArguments(builder);
                break;
            }
            case API_ID_AWARE: {
                this.appendApiIdAwareAfterArguments(builder);
                break;
            }
            case BASIC: {
                this.appendCustomAfterArguments(builder);
            }
        }
    }

    private void appendSimpleAfterArguments(CodeBuilder builder) {
        builder.format("%1$s, %2$s, %3$s, %4$s", this.getTarget(), this.getArguments(), this.getReturnValue(), this.getException());
    }

    private void appendStaticAfterArguments(CodeBuilder builder) {
        builder.format("%1$s, \"%2$s\", \"%3$s\", \"%4$s\", %5$s, %6$s, %7$s", this.getTarget(), this.targetClass.getName(), this.targetMethod.getName(), this.getParameterTypes(), this.getArguments(), this.getReturnValue(), this.getException());
    }

    private void appendApiIdAwareAfterArguments(CodeBuilder builder) {
        builder.format("%1$s, %2$d, %3$s, %4$s, %5$s", this.getTarget(), this.getApiId(), this.getArguments(), this.getReturnValue(), this.getException());
    }

    private void appendCustomAfterArguments(CodeBuilder builder) {
        Method interceptorMethod = this.interceptorDefinition.getAfterMethod();
        if (interceptorMethod.getParameterCount() == 0) {
            return;
        }
        builder.append(this.getTarget());
        Class<?>[] interceptorParamTypes = interceptorMethod.getParameterTypes();
        int parameterSize = this.parameterBind(builder, interceptorParamTypes);
        int bindSize = parameterSize + 3;
        if (bindSize != interceptorParamTypes.length) {
            throw new IllegalStateException("interceptor arguments not matched. interceptorSize:" + interceptorParamTypes.length + " bindSize:" + bindSize);
        }
        builder.append(", ");
        builder.append(this.getReturnValue());
        builder.append(", ");
        builder.append(this.getException());
    }

    private int parameterBind(CodeBuilder builder, Class<?>[] interceptorParamTypes) {
        int parameterIndex;
        int methodArgNum = this.targetMethod.getParameterTypes().length;
        int interceptorArgNum = interceptorParamTypes.length - 3;
        int matchNum = Math.min(methodArgNum, interceptorArgNum);
        for (parameterIndex = 0; parameterIndex < matchNum; ++parameterIndex) {
            builder.append(", ($w)$" + (parameterIndex + 1));
        }
        while (parameterIndex < interceptorArgNum) {
            builder.append(", null");
            ++parameterIndex;
        }
        return parameterIndex;
    }
}

