/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.recorder;

import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.common.trace.LoggingInfo;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.profiler.context.Annotation;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.errorhandler.IgnoreErrorHandler;
import com.navercorp.pinpoint.profiler.context.exception.ExceptionRecorder;
import com.navercorp.pinpoint.profiler.context.id.Shared;
import com.navercorp.pinpoint.profiler.context.recorder.AbstractRecorder;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.StringMetaDataService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultSpanRecorder
extends AbstractRecorder
implements SpanRecorder {
    private static final Logger logger = LogManager.getLogger(DefaultSpanRecorder.class);
    private static final boolean isDebug = logger.isDebugEnabled();
    private final Span span;

    public DefaultSpanRecorder(Span span, StringMetaDataService stringMetaDataService, SqlMetaDataService sqlMetaDataService, IgnoreErrorHandler errorHandler, ExceptionRecorder exceptionRecorder) {
        super(stringMetaDataService, sqlMetaDataService, errorHandler, exceptionRecorder);
        this.span = span;
    }

    public void recordStartTime(long startTime) {
        this.span.setStartTime(startTime);
    }

    @Override
    void setExceptionInfo(int exceptionClassId, String exceptionMessage) {
        this.span.setExceptionInfo(exceptionClassId, exceptionMessage);
    }

    @Override
    void recordDetailedException(Throwable throwable) {
    }

    @Override
    void maskErrorCode(int errorCode) {
        this.getShared().maskErrorCode(errorCode);
    }

    public void recordApiId(int apiId) {
        this.setApiId0(apiId);
    }

    @Override
    void setApiId0(int apiId) {
        this.span.setApiId(apiId);
    }

    @Override
    void addAnnotation(Annotation<?> annotation) {
        this.span.addAnnotation(annotation);
    }

    public void recordServiceType(ServiceType serviceType) {
        this.span.setServiceType(serviceType.getCode());
    }

    public void recordRpcName(String rpc) {
        this.getShared().setRpcName(rpc);
    }

    public void recordRemoteAddress(String remoteAddress) {
        this.span.setRemoteAddr(remoteAddress);
    }

    public void recordEndPoint(String endPoint) {
        this.getShared().setEndPoint(endPoint);
    }

    public void recordParentApplication(String parentApplicationName, short parentApplicationType) {
        this.span.setParentApplicationName(parentApplicationName);
        this.span.setParentApplicationType(parentApplicationType);
        if (isDebug) {
            logger.debug("ParentApplicationName marked. parentApplicationName={}", (Object)parentApplicationName);
        }
    }

    public void recordAcceptorHost(String host) {
        this.span.setAcceptorHost(host);
        if (isDebug) {
            logger.debug("Acceptor host received. host={}", (Object)host);
        }
    }

    public boolean canSampled() {
        return true;
    }

    public boolean isRoot() {
        return this.span.getTraceRoot().getTraceId().isRoot();
    }

    public void recordLogging(LoggingInfo loggingInfo) {
        this.getShared().setLoggingInfo(loggingInfo.getCode());
    }

    public void recordTime(boolean autoTimeRecoding) {
        this.span.setTimeRecording(autoTimeRecoding);
        if (autoTimeRecoding) {
            if (this.span.getStartTime() != 0L) {
                this.span.markBeforeTime();
            }
        } else {
            this.span.setElapsedTime(0);
            this.span.setStartTime(0L);
        }
    }

    public Object attachFrameObject(Object frameObject) {
        return this.span.attachFrameObject(frameObject);
    }

    public Object getFrameObject() {
        return this.span.getFrameObject();
    }

    public Object detachFrameObject() {
        return this.span.detachFrameObject();
    }

    public void recordStatusCode(int statusCode) {
        this.getShared().setStatusCode(statusCode);
    }

    private Shared getShared() {
        return this.span.getTraceRoot().getShared();
    }

    public boolean recordUriTemplate(String uriTemplate) {
        return this.recordUriTemplate(uriTemplate, false);
    }

    public boolean recordUriTemplate(String uriTemplate, boolean force) {
        return this.getShared().setUriTemplate(uriTemplate, force);
    }

    public boolean recordUriHttpMethod(String httpMethod) {
        return this.getShared().setHttpMethods(httpMethod);
    }
}

