/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.exception;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.common.profiler.message.EnhancedDataSender;
import com.navercorp.pinpoint.io.ResponseMessage;
import com.navercorp.pinpoint.profiler.context.exception.storage.ExceptionStorageFactory;
import com.navercorp.pinpoint.profiler.context.module.MetadataDataSender;
import com.navercorp.pinpoint.profiler.context.monitor.config.ExceptionTraceConfig;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import java.util.Objects;

public class ExceptionStorageFactoryProvider
implements Provider<ExceptionStorageFactory> {
    private final ExceptionTraceConfig exceptionTraceConfig;
    private final EnhancedDataSender<MetaDataType, ResponseMessage> spanTypeDataSender;

    @Inject
    public ExceptionStorageFactoryProvider(ExceptionTraceConfig exceptionTraceConfig, @MetadataDataSender EnhancedDataSender<MetaDataType, ResponseMessage> metadataDataSender) {
        this.exceptionTraceConfig = Objects.requireNonNull(exceptionTraceConfig, "exceptionTraceConfig");
        this.spanTypeDataSender = metadataDataSender;
    }

    public ExceptionStorageFactory get() {
        return this.newStorageFactory();
    }

    private ExceptionStorageFactory newStorageFactory() {
        return new ExceptionStorageFactory(this.spanTypeDataSender, this.exceptionTraceConfig.getIoBufferingBufferSize());
    }
}

