/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.sampler.TraceSampler;
import com.navercorp.pinpoint.profiler.context.BaseTraceFactory;
import com.navercorp.pinpoint.profiler.context.CallStackFactory;
import com.navercorp.pinpoint.profiler.context.DefaultBaseTraceFactory;
import com.navercorp.pinpoint.profiler.context.LoggingBaseTraceFactory;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.SpanFactory;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceRepository;
import com.navercorp.pinpoint.profiler.context.id.TraceRootFactory;
import com.navercorp.pinpoint.profiler.context.recorder.RecorderFactory;
import com.navercorp.pinpoint.profiler.context.storage.StorageFactory;
import com.navercorp.pinpoint.profiler.context.storage.UriStatStorage;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseTraceFactoryProvider
implements Provider<BaseTraceFactory> {
    private final TraceRootFactory traceRootFactory;
    private final StorageFactory storageFactory;
    private final TraceSampler traceSampler;
    private final CallStackFactory<SpanEvent> callStackFactory;
    private final SpanFactory spanFactory;
    private final RecorderFactory recorderFactory;
    private final ActiveTraceRepository activeTraceRepository;
    private final UriStatStorage uriStatStorage;

    @Inject
    public BaseTraceFactoryProvider(TraceRootFactory traceRootFactory, StorageFactory storageFactory, TraceSampler traceSampler, CallStackFactory<SpanEvent> callStackFactory, SpanFactory spanFactory, RecorderFactory recorderFactory, ActiveTraceRepository activeTraceRepository, UriStatStorage uriStatStorage) {
        this.traceRootFactory = Objects.requireNonNull(traceRootFactory, "traceRootFactory");
        this.callStackFactory = Objects.requireNonNull(callStackFactory, "callStackFactory");
        this.storageFactory = Objects.requireNonNull(storageFactory, "storageFactory");
        this.traceSampler = Objects.requireNonNull(traceSampler, "traceSampler");
        this.spanFactory = Objects.requireNonNull(spanFactory, "spanFactory");
        this.recorderFactory = Objects.requireNonNull(recorderFactory, "recorderFactory");
        this.activeTraceRepository = Objects.requireNonNull(activeTraceRepository, "activeTraceRepository");
        this.uriStatStorage = Objects.requireNonNull(uriStatStorage, "uriStatStorage");
    }

    public BaseTraceFactory get() {
        BaseTraceFactory baseTraceFactory = new DefaultBaseTraceFactory(this.traceRootFactory, this.callStackFactory, this.storageFactory, this.traceSampler, this.spanFactory, this.recorderFactory, this.activeTraceRepository, this.uriStatStorage);
        if (this.isDebugEnabled()) {
            baseTraceFactory = LoggingBaseTraceFactory.wrap(baseTraceFactory);
        }
        return baseTraceFactory;
    }

    private boolean isDebugEnabled() {
        Logger logger = LogManager.getLogger(DefaultBaseTraceFactory.class);
        return logger.isDebugEnabled();
    }
}

