/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.monitor.metric;

import com.navercorp.pinpoint.bootstrap.plugin.monitor.metric.CustomMetric;
import com.navercorp.pinpoint.bootstrap.plugin.monitor.metric.LongCounter;
import com.navercorp.pinpoint.profiler.context.monitor.metric.CustomMetricRegistryFilter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class DefaultCustomMetricRegistryFilter
implements CustomMetricRegistryFilter {
    private static final AllowedSource<LongCounter> NETTY_USED_DIRECT_MEMORY = new AllowedSource<LongCounter>("custom/netty/usedDirectMemory", LongCounter.class);
    private static final AllowedSource<LongCounter> NETTY_MAX_DIRECT_MEMORY = new AllowedSource<LongCounter>("custom/netty/maxDirectMemory ", LongCounter.class);
    private final AllowedSource<? extends CustomMetric>[] allowedSourceList;

    public DefaultCustomMetricRegistryFilter() {
        this(Arrays.asList(NETTY_USED_DIRECT_MEMORY, NETTY_MAX_DIRECT_MEMORY));
    }

    public DefaultCustomMetricRegistryFilter(List<AllowedSource<? extends CustomMetric>> allowedSourceList) {
        Objects.requireNonNull(allowedSourceList, "allowedSourceList");
        this.allowedSourceList = allowedSourceList.toArray(new AllowedSource[0]);
    }

    public boolean filter(CustomMetric value) {
        Objects.requireNonNull(value, "value");
        for (AllowedSource<? extends CustomMetric> allowedSource : this.allowedSourceList) {
            if (!this.contains(allowedSource, value)) continue;
            return false;
        }
        return true;
    }

    private boolean contains(AllowedSource<? extends CustomMetric> allowedSource, CustomMetric value) {
        if (!allowedSource.getMetricName().equals(value.getName())) {
            return false;
        }
        return allowedSource.getMetricClazz().isInstance(value);
    }

    public static class AllowedSource<T extends CustomMetric> {
        private final String metricName;
        private final Class<T> metricClazz;

        public AllowedSource(String metricName, Class<T> metricClazz) {
            this.metricName = Objects.requireNonNull(metricName, "metricName");
            this.metricClazz = Objects.requireNonNull(metricClazz, "metricClazz");
        }

        public String getMetricName() {
            return this.metricName;
        }

        public Class<T> getMetricClazz() {
            return this.metricClazz;
        }
    }
}

