/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.errorhandler;

import com.navercorp.pinpoint.profiler.context.errorhandler.IgnoreErrorHandler;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NestedErrorHandler
implements IgnoreErrorHandler {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final IgnoreErrorHandler errorHandler;

    public NestedErrorHandler(IgnoreErrorHandler errorHandler) {
        this.errorHandler = Objects.requireNonNull(errorHandler, "errorHandler");
    }

    @Override
    public boolean handleError(Throwable th) {
        while (th != null) {
            if (this.errorHandler.handleError(th)) {
                return true;
            }
            th = th.getCause();
        }
        return false;
    }

    public String toString() {
        return "NestedErrorHandler{errorHandler=" + this.errorHandler + '}';
    }
}

