/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.profiler.context.CallStack;
import com.navercorp.pinpoint.profiler.context.CallStackFactory;
import com.navercorp.pinpoint.profiler.context.CallStackOverflowListener;
import com.navercorp.pinpoint.profiler.context.DefaultCallStack;
import com.navercorp.pinpoint.profiler.context.DefaultCallStackOverflowListener;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.SpanEventFactory;
import com.navercorp.pinpoint.profiler.context.ThrottledLogCallStackOverflowListener;

public class CallStackFactoryV2
implements CallStackFactory<SpanEvent> {
    private final CallStack.Factory<SpanEvent> factory = new SpanEventFactory();
    private final int maxDepth;
    private final int maxSequence;
    private final CallStackOverflowListener overflowListener;

    public CallStackFactoryV2(int maxDepth, int maxSequence, int overflowLogRation) {
        this.maxDepth = maxDepth;
        this.maxSequence = maxSequence;
        this.overflowListener = overflowLogRation > 1 ? new ThrottledLogCallStackOverflowListener(maxDepth, maxSequence, overflowLogRation) : new DefaultCallStackOverflowListener(maxDepth, maxSequence);
    }

    @Override
    public CallStack<SpanEvent> newCallStack() {
        DefaultCallStack<SpanEvent> callStack = new DefaultCallStack<SpanEvent>(this.factory, this.maxDepth, this.maxSequence);
        callStack.setOverflowListener(this.overflowListener);
        return callStack;
    }
}

