/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.api;

import io.cloudevents.CloudEvent;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.protocol.api.exception.ProtocolHandleException;
import org.apache.eventmesh.spi.EventMeshExtensionType;
import org.apache.eventmesh.spi.EventMeshSPI;

@EventMeshSPI(eventMeshExtensionType=EventMeshExtensionType.PROTOCOL)
public interface ProtocolAdaptor<T extends ProtocolTransportObject> {
    default public void initialize() {
    }

    default public void destroy() {
    }

    public CloudEvent toCloudEvent(T var1) throws ProtocolHandleException;

    public List<CloudEvent> toBatchCloudEvent(T var1) throws ProtocolHandleException;

    public ProtocolTransportObject fromCloudEvent(CloudEvent var1) throws ProtocolHandleException;

    public String getProtocolType();

    default public int getPriority() {
        return 50;
    }

    default public boolean supportsBatchProcessing() {
        return true;
    }

    default public String getVersion() {
        return "1.0";
    }

    default public Set<String> getCapabilities() {
        return Collections.emptySet();
    }

    default public boolean isValid(T protocol) {
        return protocol != null;
    }
}

