/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.pravega.client.admin.KeyValueTableInfo;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.tables.ConditionalTableUpdateException;
import io.pravega.client.tables.KeyValueTable;
import io.pravega.client.tables.KeyValueTableConfiguration;
import io.pravega.client.tables.Remove;
import io.pravega.client.tables.TableEntry;
import io.pravega.client.tables.TableEntryUpdate;
import io.pravega.client.tables.TableKey;
import io.pravega.client.tables.TableModification;
import io.pravega.client.tables.Version;
import io.pravega.client.tables.impl.KeyValueTableIteratorImpl;
import io.pravega.client.tables.impl.SegmentSelector;
import io.pravega.client.tables.impl.TableEntryHelper;
import io.pravega.client.tables.impl.TableSegment;
import io.pravega.client.tables.impl.TableSegmentEntry;
import io.pravega.client.tables.impl.TableSegmentFactory;
import io.pravega.client.tables.impl.TableSegmentKey;
import io.pravega.client.tables.impl.TableSegmentKeyVersion;
import io.pravega.client.tables.impl.VersionImpl;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import java.beans.ConstructorProperties;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueTableImpl
implements KeyValueTable,
AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeyValueTableImpl.class);
    private final SegmentSelector selector;
    private final String logTraceId;
    private final AtomicBoolean closed;
    private final KeyValueTableConfiguration config;
    private final TableEntryHelper entryHelper;
    private final Executor executor;

    KeyValueTableImpl(@NonNull KeyValueTableInfo kvt, @NonNull TableSegmentFactory tableSegmentFactory, @NonNull Controller controller, @NonNull Executor executor) {
        if (kvt == null) {
            throw new NullPointerException("kvt is marked non-null but is null");
        }
        if (tableSegmentFactory == null) {
            throw new NullPointerException("tableSegmentFactory is marked non-null but is null");
        }
        if (controller == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.executor = executor;
        this.selector = new SegmentSelector(kvt, controller, tableSegmentFactory);
        this.config = this.getConfig(kvt, controller);
        this.entryHelper = new TableEntryHelper(this.selector, this.config);
        this.logTraceId = String.format("KeyValueTable[%s]", kvt.getScopedName());
        this.closed = new AtomicBoolean(false);
        Preconditions.checkArgument((this.config.getPartitionCount() == this.selector.getSegmentCount() ? 1 : 0) != 0, (String)"Inconsistent Segment Count. Expected %s, actual %s.", (int)this.config.getPartitionCount(), (int)this.selector.getSegmentCount());
        log.info("{}: Initialized. Config: {}.", (Object)this.logTraceId, (Object)this.config);
    }

    private KeyValueTableConfiguration getConfig(KeyValueTableInfo kvt, Controller controller) {
        return (KeyValueTableConfiguration)Futures.getAndHandleExceptions(controller.getKeyValueTableConfiguration(kvt.getScope(), kvt.getKeyValueTableName()), RuntimeException::new);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.selector.close();
            log.info("{}: Closed.", (Object)this.logTraceId);
        }
    }

    @Override
    public CompletableFuture<Version> update(@NonNull TableModification update) {
        if (update == null) {
            throw new NullPointerException("update is marked non-null but is null");
        }
        TableSegment s = this.selector.getTableSegment(update.getKey().getPrimaryKey());
        if (update.isRemoval()) {
            UpdateArg removeArgs = new UpdateArg(update.getKey().getPrimaryKey(), s, Iterators.singletonIterator((Object)this.entryHelper.toTableSegmentKey(s, (Remove)update)));
            return this.removeFromSegment(removeArgs.getTableSegment(), removeArgs.getAllArgs()).thenApply(r -> null);
        }
        UpdateArg updateArgs = new UpdateArg(update.getKey().getPrimaryKey(), s, Iterators.singletonIterator((Object)this.entryHelper.toTableSegmentEntry(s, (TableEntryUpdate)update)));
        return this.updateToSegment(updateArgs.getTableSegment(), updateArgs.getAllArgs()).thenApply(r -> (Version)r.get(0));
    }

    @Override
    public CompletableFuture<List<Version>> update(@NonNull Iterable<TableModification> updates) {
        if (updates == null) {
            throw new NullPointerException("updates is marked non-null but is null");
        }
        Iterator<TableModification> inputIterator = updates.iterator();
        if (!inputIterator.hasNext()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        TableModification firstInput = inputIterator.next();
        TableSegment ts = this.selector.getTableSegment(firstInput.getKey().getPrimaryKey());
        if (firstInput.isRemoval()) {
            UpdateArg<TableSegmentKey> args = this.toArg(firstInput, inputIterator, ts, u -> this.entryHelper.toTableSegmentKey(ts, (Remove)u));
            return this.removeFromSegment(args.getTableSegment(), args.getAllArgs()).thenApply(r -> Collections.emptyList());
        }
        UpdateArg<TableSegmentEntry> args = this.toArg(firstInput, inputIterator, ts, u -> this.entryHelper.toTableSegmentEntry(ts, (TableEntryUpdate)u));
        return this.updateToSegment(args.getTableSegment(), args.getAllArgs());
    }

    @Override
    public CompletableFuture<Boolean> exists(@NonNull TableKey key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.update(new Remove(key, Version.NOT_EXISTS)).handle((r, ex) -> {
            if (ex != null) {
                if ((ex = Exceptions.unwrap((Throwable)ex)) instanceof ConditionalTableUpdateException) {
                    return true;
                }
                throw new CompletionException((Throwable)ex);
            }
            return false;
        });
    }

    @Override
    public CompletableFuture<TableEntry> get(@NonNull TableKey key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getAll(Collections.singleton(key)).thenApply(r -> (TableEntry)r.get(0));
    }

    @Override
    public CompletableFuture<List<TableEntry>> getAll(@NonNull Iterable<TableKey> keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        HashMap<TableSegment, KeyGroup> bySegment = new HashMap<TableSegment, KeyGroup>();
        AtomicInteger count = new AtomicInteger(0);
        keys.forEach(k -> {
            TableSegment ts = this.selector.getTableSegment(k.getPrimaryKey());
            KeyGroup g = bySegment.computeIfAbsent(ts, t -> new KeyGroup());
            g.add(this.entryHelper.serializeKey((TableKey)k), count.getAndIncrement());
        });
        HashMap futures = new HashMap();
        bySegment.forEach((ts, kg) -> futures.put(ts, ts.get(kg.keys.iterator())));
        return Futures.allOf(futures.values()).thenApply(v -> {
            TableEntry[] r = new TableEntry[count.get()];
            futures.forEach((ts, f) -> {
                KeyGroup kg = (KeyGroup)bySegment.get(ts);
                assert (f.isDone()) : "incomplete CompletableFuture returned by Futures.allOf";
                List segmentResult = (List)f.join();
                assert (segmentResult.size() == kg.ordinals.size()) : "segmentResult count mismatch";
                for (int i = 0; i < kg.ordinals.size(); ++i) {
                    assert (r[kg.ordinals.get(i)] == null) : "overlapping ordinals";
                    r[kg.ordinals.get((int)i).intValue()] = this.entryHelper.fromTableSegmentEntry((TableSegment)ts, (TableSegmentEntry)segmentResult.get(i));
                }
            });
            return Arrays.asList(r);
        });
    }

    @Override
    public KeyValueTableIteratorImpl.Builder iterator() {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        return new KeyValueTableIteratorImpl.Builder(this.config, this.entryHelper, this.executor);
    }

    private <T> UpdateArg<T> toArg(TableModification firstInput, Iterator<TableModification> inputIterator, TableSegment ts, Function<TableModification, T> convert) {
        UnmodifiableIterator firstInputIterator = Iterators.singletonIterator(convert.apply(firstInput));
        Iterator restIterator = Iterators.transform(inputIterator, i -> {
            ByteBuffer pk = i.getKey().getPrimaryKey();
            Preconditions.checkArgument((boolean)firstInput.getKey().getPrimaryKey().equals(pk), (Object)"All Keys must have the same Primary Key.");
            Preconditions.checkArgument((firstInput.isRemoval() == i.isRemoval() ? 1 : 0) != 0, (Object)"Cannot combine Removals with Updates.");
            return convert.apply((TableModification)i);
        });
        return new UpdateArg(firstInput.getKey().getPrimaryKey(), ts, Iterators.concat((Iterator)firstInputIterator, (Iterator)restIterator));
    }

    private CompletableFuture<List<Version>> updateToSegment(TableSegment segment, Iterator<TableSegmentEntry> tableSegmentEntries) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        return segment.put(tableSegmentEntries).thenApply(versions -> versions.stream().map(v -> new VersionImpl(segment.getSegmentId(), (TableSegmentKeyVersion)v)).collect(Collectors.toList()));
    }

    private CompletableFuture<Void> removeFromSegment(TableSegment segment, Iterator<TableSegmentKey> tableSegmentKeys) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        return segment.remove(tableSegmentKeys);
    }

    private static class UpdateArg<T> {
        private final ByteBuffer primaryKey;
        private final TableSegment tableSegment;
        private final Iterator<T> allArgs;

        @ConstructorProperties(value={"primaryKey", "tableSegment", "allArgs"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UpdateArg(ByteBuffer primaryKey, TableSegment tableSegment, Iterator<T> allArgs) {
            this.primaryKey = primaryKey;
            this.tableSegment = tableSegment;
            this.allArgs = allArgs;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ByteBuffer getPrimaryKey() {
            return this.primaryKey;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableSegment getTableSegment() {
            return this.tableSegment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Iterator<T> getAllArgs() {
            return this.allArgs;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateArg)) {
                return false;
            }
            UpdateArg other = (UpdateArg)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ByteBuffer this$primaryKey = this.getPrimaryKey();
            ByteBuffer other$primaryKey = other.getPrimaryKey();
            if (this$primaryKey == null ? other$primaryKey != null : !((Object)this$primaryKey).equals(other$primaryKey)) {
                return false;
            }
            TableSegment this$tableSegment = this.getTableSegment();
            TableSegment other$tableSegment = other.getTableSegment();
            if (this$tableSegment == null ? other$tableSegment != null : !this$tableSegment.equals(other$tableSegment)) {
                return false;
            }
            Iterator<T> this$allArgs = this.getAllArgs();
            Iterator<T> other$allArgs = other.getAllArgs();
            return !(this$allArgs == null ? other$allArgs != null : !this$allArgs.equals(other$allArgs));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UpdateArg;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteBuffer $primaryKey = this.getPrimaryKey();
            result = result * 59 + ($primaryKey == null ? 43 : ((Object)$primaryKey).hashCode());
            TableSegment $tableSegment = this.getTableSegment();
            result = result * 59 + ($tableSegment == null ? 43 : $tableSegment.hashCode());
            Iterator<T> $allArgs = this.getAllArgs();
            result = result * 59 + ($allArgs == null ? 43 : $allArgs.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "KeyValueTableImpl.UpdateArg(primaryKey=" + this.getPrimaryKey() + ", tableSegment=" + this.getTableSegment() + ", allArgs=" + this.getAllArgs() + ")";
        }
    }

    private static class KeyGroup {
        final ArrayList<ByteBuf> keys = new ArrayList();
        final ArrayList<Integer> ordinals = new ArrayList();

        private KeyGroup() {
        }

        void add(ByteBuf key, int ordinal) {
            this.keys.add(key);
            this.ordinals.add(ordinal);
        }
    }
}

