/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.connector;

import com.google.protobuf.Any;
import com.google.protobuf.UnsafeByteOperations;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.consumer.Consumer;
import org.apache.eventmesh.api.factory.StoragePluginFactory;
import org.apache.eventmesh.api.producer.Producer;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.config.ConfigService;
import org.apache.eventmesh.common.config.connector.SinkConfig;
import org.apache.eventmesh.common.config.connector.SourceConfig;
import org.apache.eventmesh.common.config.connector.offset.OffsetStorageConfig;
import org.apache.eventmesh.common.enums.ConnectorStage;
import org.apache.eventmesh.common.protocol.grpc.adminserver.AdminServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.adminserver.Metadata;
import org.apache.eventmesh.common.protocol.grpc.adminserver.Payload;
import org.apache.eventmesh.common.remote.JobState;
import org.apache.eventmesh.common.remote.request.FetchJobRequest;
import org.apache.eventmesh.common.remote.response.FetchJobResponse;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.openconnect.api.ConnectorCreateService;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.factory.ConnectorPluginFactory;
import org.apache.eventmesh.openconnect.api.monitor.Monitor;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.callback.SendExceptionContext;
import org.apache.eventmesh.openconnect.offsetmgmt.api.callback.SendMessageCallback;
import org.apache.eventmesh.openconnect.offsetmgmt.api.callback.SendResult;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.RecordOffsetManagement;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.DefaultOffsetManagementServiceImpl;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.OffsetManagementService;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.OffsetStorageReader;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.OffsetStorageReaderImpl;
import org.apache.eventmesh.openconnect.offsetmgmt.api.storage.OffsetStorageWriterImpl;
import org.apache.eventmesh.openconnect.util.ConfigUtil;
import org.apache.eventmesh.runtime.Runtime;
import org.apache.eventmesh.runtime.RuntimeInstanceConfig;
import org.apache.eventmesh.runtime.connector.ConnectorRuntimeConfig;
import org.apache.eventmesh.runtime.service.health.HealthService;
import org.apache.eventmesh.runtime.service.monitor.MonitorService;
import org.apache.eventmesh.runtime.service.monitor.SinkMonitor;
import org.apache.eventmesh.runtime.service.monitor.SourceMonitor;
import org.apache.eventmesh.runtime.service.status.StatusService;
import org.apache.eventmesh.runtime.service.verify.VerifyService;
import org.apache.eventmesh.runtime.util.RuntimeUtils;
import org.apache.eventmesh.spi.EventMeshExtensionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorRuntime
implements Runtime {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectorRuntime.class);
    private RuntimeInstanceConfig runtimeInstanceConfig;
    private ConnectorRuntimeConfig connectorRuntimeConfig;
    private ManagedChannel channel;
    private AdminServiceGrpc.AdminServiceStub adminServiceStub;
    private AdminServiceGrpc.AdminServiceBlockingStub adminServiceBlockingStub;
    private Source sourceConnector;
    private Sink sinkConnector;
    private OffsetStorageWriterImpl offsetStorageWriter;
    private OffsetStorageReaderImpl offsetStorageReader;
    private OffsetManagementService offsetManagementService;
    private RecordOffsetManagement offsetManagement;
    private volatile RecordOffsetManagement.CommittableOffsets committableOffsets;
    private Producer producer;
    private Consumer consumer;
    private final ExecutorService sourceService = ThreadPoolFactory.createSingleExecutor((String)"eventMesh-sourceService");
    private final ExecutorService sinkService = ThreadPoolFactory.createSingleExecutor((String)"eventMesh-sinkService");
    private final BlockingQueue<ConnectRecord> queue;
    private volatile boolean isRunning = false;
    private volatile boolean isFailed = false;
    public static final String CALLBACK_EXTENSION = "callBackExtension";
    private String adminServerAddr;
    private HealthService healthService;
    private MonitorService monitorService;
    private SourceMonitor sourceMonitor;
    private SinkMonitor sinkMonitor;
    private VerifyService verifyService;
    private StatusService statusService;

    public ConnectorRuntime(RuntimeInstanceConfig runtimeInstanceConfig) {
        this.runtimeInstanceConfig = runtimeInstanceConfig;
        this.queue = new LinkedBlockingQueue<ConnectRecord>(1000);
    }

    @Override
    public void init() throws Exception {
        this.initAdminService();
        this.initStorageService();
        this.initStatusService();
        this.initConnectorService();
        this.initMonitorService();
        this.initHealthService();
        this.initVerfiyService();
    }

    private void initAdminService() {
        this.adminServerAddr = RuntimeUtils.getRandomAdminServerAddr(this.runtimeInstanceConfig.getAdminServiceAddr());
        this.channel = ManagedChannelBuilder.forTarget((String)this.adminServerAddr).usePlaintext().enableRetry().maxRetryAttempts(3).build();
        this.adminServiceStub = (AdminServiceGrpc.AdminServiceStub)AdminServiceGrpc.newStub((Channel)this.channel).withWaitForReady();
        this.adminServiceBlockingStub = (AdminServiceGrpc.AdminServiceBlockingStub)AdminServiceGrpc.newBlockingStub((Channel)this.channel).withWaitForReady();
    }

    private void initStorageService() {
        this.producer = StoragePluginFactory.getMeshMQProducer((String)this.runtimeInstanceConfig.getStoragePluginType());
        this.consumer = StoragePluginFactory.getMeshMQPushConsumer((String)this.runtimeInstanceConfig.getStoragePluginType());
    }

    private void initStatusService() {
        this.statusService = new StatusService(this.adminServiceStub, this.adminServiceBlockingStub);
    }

    private void initConnectorService() throws Exception {
        this.connectorRuntimeConfig = (ConnectorRuntimeConfig)ConfigService.getInstance().buildConfigInstance(ConnectorRuntimeConfig.class);
        FetchJobResponse jobResponse = this.fetchJobConfig();
        log.info("fetch job config from admin server: {}", (Object)JsonUtils.toJSONString((Object)jobResponse));
        if (jobResponse == null) {
            this.isFailed = true;
            this.stop();
            throw new RuntimeException("fetch job config fail");
        }
        this.connectorRuntimeConfig.setSourceConnectorType(jobResponse.getTransportType().getSrc().getName());
        this.connectorRuntimeConfig.setSourceConnectorDesc(jobResponse.getConnectorConfig().getSourceConnectorDesc());
        this.connectorRuntimeConfig.setSourceConnectorConfig(jobResponse.getConnectorConfig().getSourceConnectorConfig());
        this.connectorRuntimeConfig.setSinkConnectorType(jobResponse.getTransportType().getDst().getName());
        this.connectorRuntimeConfig.setSinkConnectorDesc(jobResponse.getConnectorConfig().getSinkConnectorDesc());
        this.connectorRuntimeConfig.setSinkConnectorConfig(jobResponse.getConnectorConfig().getSinkConnectorConfig());
        this.offsetManagement = new RecordOffsetManagement();
        this.committableOffsets = RecordOffsetManagement.CommittableOffsets.EMPTY;
        OffsetStorageConfig offsetStorageConfig = new OffsetStorageConfig();
        offsetStorageConfig.setOffsetStorageAddr(this.connectorRuntimeConfig.getRuntimeConfig().get("offsetStorageAddr").toString());
        offsetStorageConfig.setOffsetStorageType(this.connectorRuntimeConfig.getRuntimeConfig().get("offsetStoragePluginType").toString());
        offsetStorageConfig.setDataSourceType(jobResponse.getTransportType().getSrc());
        offsetStorageConfig.setDataSinkType(jobResponse.getTransportType().getDst());
        HashMap<String, String> offsetStorageExtensions = new HashMap<String, String>();
        offsetStorageExtensions.put("jobId", this.connectorRuntimeConfig.getJobID());
        offsetStorageConfig.setExtensions(offsetStorageExtensions);
        this.offsetManagementService = Optional.ofNullable(offsetStorageConfig).map(OffsetStorageConfig::getOffsetStorageType).map(storageType -> (OffsetManagementService)EventMeshExtensionFactory.getExtension(OffsetManagementService.class, (String)storageType)).orElse((OffsetManagementService)new DefaultOffsetManagementServiceImpl());
        this.offsetManagementService.initialize(offsetStorageConfig);
        this.offsetStorageWriter = new OffsetStorageWriterImpl(this.offsetManagementService);
        this.offsetStorageReader = new OffsetStorageReaderImpl(this.offsetManagementService);
        ConnectorCreateService sourceConnectorCreateService = ConnectorPluginFactory.createConnector((String)(this.connectorRuntimeConfig.getSourceConnectorType() + "-Source"));
        this.sourceConnector = (Source)sourceConnectorCreateService.create();
        SourceConfig sourceConfig = (SourceConfig)ConfigUtil.parse(this.connectorRuntimeConfig.getSourceConnectorConfig(), (Class)this.sourceConnector.configClass());
        SourceConnectorContext sourceConnectorContext = new SourceConnectorContext();
        sourceConnectorContext.setSourceConfig(sourceConfig);
        sourceConnectorContext.setRuntimeConfig(this.connectorRuntimeConfig.getRuntimeConfig());
        sourceConnectorContext.setJobType(jobResponse.getType());
        sourceConnectorContext.setOffsetStorageReader((OffsetStorageReader)this.offsetStorageReader);
        if (CollectionUtils.isNotEmpty((Collection)jobResponse.getPosition())) {
            sourceConnectorContext.setRecordPositionList(jobResponse.getPosition());
        }
        this.sourceConnector.init((ConnectorContext)sourceConnectorContext);
        ConnectorCreateService sinkConnectorCreateService = ConnectorPluginFactory.createConnector((String)(this.connectorRuntimeConfig.getSinkConnectorType() + "-Sink"));
        this.sinkConnector = (Sink)sinkConnectorCreateService.create();
        SinkConfig sinkConfig = (SinkConfig)ConfigUtil.parse(this.connectorRuntimeConfig.getSinkConnectorConfig(), (Class)this.sinkConnector.configClass());
        SinkConnectorContext sinkConnectorContext = new SinkConnectorContext();
        sinkConnectorContext.setSinkConfig(sinkConfig);
        sinkConnectorContext.setRuntimeConfig(this.connectorRuntimeConfig.getRuntimeConfig());
        sinkConnectorContext.setJobType(jobResponse.getType());
        this.sinkConnector.init((ConnectorContext)sinkConnectorContext);
        this.statusService.reportJobStatus(this.connectorRuntimeConfig.getJobID(), JobState.INIT);
    }

    private FetchJobResponse fetchJobConfig() {
        String jobId = this.connectorRuntimeConfig.getJobID();
        FetchJobRequest jobRequest = new FetchJobRequest();
        jobRequest.setJobID(jobId);
        Metadata metadata = Metadata.newBuilder().setType(FetchJobRequest.class.getSimpleName()).build();
        Payload request = Payload.newBuilder().setMetadata(metadata).setBody(Any.newBuilder().setValue(UnsafeByteOperations.unsafeWrap((byte[])Objects.requireNonNull(JsonUtils.toJSONBytes((Object)jobRequest)))).build()).build();
        Payload response = this.adminServiceBlockingStub.invoke(request);
        if (response.getMetadata().getType().equals(FetchJobResponse.class.getSimpleName())) {
            return (FetchJobResponse)JsonUtils.parseObject((String)response.getBody().getValue().toStringUtf8(), FetchJobResponse.class);
        }
        return null;
    }

    private void initMonitorService() {
        this.monitorService = new MonitorService(this.adminServiceStub, this.adminServiceBlockingStub);
        this.sourceMonitor = new SourceMonitor(this.connectorRuntimeConfig.getTaskID(), this.connectorRuntimeConfig.getJobID(), IPUtils.getLocalAddress());
        this.monitorService.registerMonitor((Monitor)this.sourceMonitor);
        this.sinkMonitor = new SinkMonitor(this.connectorRuntimeConfig.getTaskID(), this.connectorRuntimeConfig.getJobID(), IPUtils.getLocalAddress());
        this.monitorService.registerMonitor((Monitor)this.sinkMonitor);
    }

    private void initHealthService() {
        this.healthService = new HealthService(this.adminServiceStub, this.adminServiceBlockingStub, this.connectorRuntimeConfig);
    }

    private void initVerfiyService() {
        this.verifyService = new VerifyService(this.adminServiceStub, this.adminServiceBlockingStub, this.connectorRuntimeConfig);
    }

    @Override
    public void start() throws Exception {
        this.offsetManagementService.start();
        this.monitorService.start();
        this.healthService.start();
        this.isRunning = true;
        this.sinkService.execute(() -> {
            try {
                this.startSinkConnector();
            }
            catch (Exception e) {
                this.isFailed = true;
                log.error("sink connector start fail", (Object[])e.getStackTrace());
                try {
                    this.stop();
                }
                catch (Exception ex) {
                    log.error("Failed to stop after exception", (Throwable)ex);
                }
            }
            finally {
                System.exit(-1);
            }
        });
        this.sourceService.execute(() -> {
            try {
                this.startSourceConnector();
            }
            catch (Exception e) {
                this.isFailed = true;
                log.error("source connector start fail", (Throwable)e);
                try {
                    this.stop();
                }
                catch (Exception ex) {
                    log.error("Failed to stop after exception", (Throwable)ex);
                }
            }
            finally {
                System.exit(-1);
            }
        });
        this.statusService.reportJobStatus(this.connectorRuntimeConfig.getJobID(), JobState.RUNNING);
    }

    @Override
    public void stop() throws Exception {
        log.info("ConnectorRuntime start stop");
        this.isRunning = false;
        if (this.isFailed) {
            this.statusService.reportJobStatus(this.connectorRuntimeConfig.getJobID(), JobState.FAIL);
        } else {
            this.statusService.reportJobStatus(this.connectorRuntimeConfig.getJobID(), JobState.COMPLETE);
        }
        this.sourceConnector.stop();
        this.sinkConnector.stop();
        this.monitorService.stop();
        this.healthService.stop();
        this.sourceService.shutdown();
        this.sinkService.shutdown();
        this.verifyService.stop();
        this.statusService.stop();
        if (this.channel != null && !this.channel.isShutdown()) {
            this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        log.info("ConnectorRuntime stopped");
    }

    private void startSourceConnector() throws Exception {
        this.sourceConnector.start();
        while (this.isRunning) {
            long sourceStartTime = System.currentTimeMillis();
            List connectorRecordList = this.sourceConnector.poll();
            final long sinkStartTime = System.currentTimeMillis();
            if (connectorRecordList == null || connectorRecordList.isEmpty()) continue;
            for (final ConnectRecord record : connectorRecordList) {
                if (record.getExtensions() == null || !record.getExtensions().containsKey("recordUniqueId")) {
                    record.addExtension("recordUniqueId", (Object)record.getRecordId());
                }
                record.setCallback(new SendMessageCallback(){

                    public void onSuccess(SendResult result) {
                        log.debug("send record to sink callback success, record: {}", (Object)record);
                        long sinkEndTime = System.currentTimeMillis();
                        ConnectorRuntime.this.sinkMonitor.recordProcess(sinkEndTime - sinkStartTime);
                        ConnectorRuntime.this.sourceConnector.commit(record);
                        if (record.getPosition() != null) {
                            Optional<RecordOffsetManagement.SubmittedPosition> submittedRecordPosition = ConnectorRuntime.this.prepareToUpdateRecordOffset(record);
                            submittedRecordPosition.ifPresent(RecordOffsetManagement.SubmittedPosition::ack);
                            log.debug("start wait all messages to commit");
                            ConnectorRuntime.this.offsetManagement.awaitAllMessages(5000L, TimeUnit.MILLISECONDS);
                            ConnectorRuntime.this.updateCommittableOffsets();
                            ConnectorRuntime.this.commitOffsets();
                        }
                        Optional<SendMessageCallback> callback = Optional.ofNullable(record.getExtensionObj(ConnectorRuntime.CALLBACK_EXTENSION)).map(v -> (SendMessageCallback)v);
                        callback.ifPresent(cb -> cb.onSuccess(ConnectorRuntime.this.convertToSendResult(record)));
                    }

                    public void onException(SendExceptionContext sendExceptionContext) {
                        ConnectorRuntime.this.isFailed = true;
                        ConnectorRuntime.this.sourceConnector.onException(record);
                        log.error("send record to sink callback exception, process will shut down, record: {}", (Object)record, (Object)sendExceptionContext.getCause());
                        try {
                            ConnectorRuntime.this.stop();
                        }
                        catch (Exception e) {
                            log.error("Failed to stop after exception", (Throwable)e);
                        }
                    }
                });
                this.queue.put(record);
                long sourceEndTime = System.currentTimeMillis();
                this.sourceMonitor.recordProcess(sourceEndTime - sourceStartTime);
                if (!this.connectorRuntimeConfig.enableIncrementalDataConsistencyCheck) continue;
                this.verifyService.reportVerifyRequest(record, ConnectorStage.SOURCE);
            }
        }
    }

    private SendResult convertToSendResult(ConnectRecord record) {
        SendResult result = new SendResult();
        result.setMessageId(record.getRecordId());
        if (StringUtils.isNotEmpty((CharSequence)record.getExtension("topic"))) {
            result.setTopic(record.getExtension("topic"));
        }
        return result;
    }

    public Optional<RecordOffsetManagement.SubmittedPosition> prepareToUpdateRecordOffset(ConnectRecord record) {
        return Optional.of(this.offsetManagement.submitRecord(record.getPosition()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCommittableOffsets() {
        RecordOffsetManagement.CommittableOffsets newOffsets = this.offsetManagement.committableOffsets();
        ConnectorRuntime connectorRuntime = this;
        synchronized (connectorRuntime) {
            this.committableOffsets = this.committableOffsets.updatedWith(newOffsets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitOffsets() {
        RecordOffsetManagement.CommittableOffsets offsetsToCommit;
        log.info("Start Committing offsets");
        long timeout = System.currentTimeMillis() + 5000L;
        ConnectorRuntime connectorRuntime = this;
        synchronized (connectorRuntime) {
            offsetsToCommit = this.committableOffsets;
            this.committableOffsets = RecordOffsetManagement.CommittableOffsets.EMPTY;
        }
        if (this.committableOffsets.isEmpty()) {
            log.debug("Either no records were produced since the last offset commit, or every record has been filtered out by a transformation or dropped due to transformation or conversion errors.");
        } else {
            log.info("{} Committing offsets for {} acknowledged messages", (Object)this, (Object)this.committableOffsets.numCommittableMessages());
            if (this.committableOffsets.hasPending()) {
                log.debug("{} There are currently {} pending messages spread across {} source partitions whose offsets will not be committed. The source partition with the most pending messages is {}, with {} pending messages", new Object[]{this, this.committableOffsets.numUncommittableMessages(), this.committableOffsets.numDeques(), this.committableOffsets.largestDequePartition(), this.committableOffsets.largestDequeSize()});
            } else {
                log.debug("{} There are currently no pending messages for this offset commit; all messages dispatched to the task's producer since the last commit have been acknowledged", (Object)this);
            }
        }
        offsetsToCommit.offsets().forEach((arg_0, arg_1) -> ((OffsetStorageWriterImpl)this.offsetStorageWriter).writeOffset(arg_0, arg_1));
        if (!this.offsetStorageWriter.beginFlush()) {
            return true;
        }
        Future flushFuture = this.offsetStorageWriter.doFlush();
        try {
            flushFuture.get(Math.max(timeout - System.currentTimeMillis(), 0L), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.warn("{} Flush of offsets interrupted, cancelling", (Object)this);
            this.offsetStorageWriter.cancelFlush();
            return false;
        }
        catch (ExecutionException e) {
            log.error("{} Flush of offsets threw an unexpected exception: ", (Object)this, (Object)e);
            this.offsetStorageWriter.cancelFlush();
            return false;
        }
        catch (TimeoutException e) {
            log.error("{} Timed out waiting to flush offsets to storage; will try again on next flush interval with latest offsets", (Object)this);
            this.offsetStorageWriter.cancelFlush();
            return false;
        }
        return true;
    }

    private void startSinkConnector() throws Exception {
        this.sinkConnector.start();
        while (this.isRunning) {
            ConnectRecord connectRecord = null;
            try {
                connectRecord = this.queue.poll(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("poll connect record error", (Throwable)e);
            }
            if (connectRecord == null) continue;
            ArrayList<ConnectRecord> connectRecordList = new ArrayList<ConnectRecord>();
            connectRecordList.add(connectRecord);
            this.sinkConnector.put(connectRecordList);
            if (!this.connectorRuntimeConfig.enableIncrementalDataConsistencyCheck) continue;
            this.verifyService.reportVerifyRequest(connectRecord, ConnectorStage.SINK);
        }
    }
}

