/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.impl.schema.SchemaUtils;
import org.apache.pulsar.client.impl.schema.generic.AbstractMultiVersionGenericReader;
import org.apache.pulsar.client.impl.schema.generic.GenericJsonReader;
import org.apache.pulsar.client.impl.schema.generic.MultiVersionGenericAvroReader;
import org.apache.pulsar.client.impl.schema.util.SchemaUtil;
import org.apache.pulsar.common.protocol.schema.BytesSchemaVersion;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiVersionGenericJsonReader
extends AbstractMultiVersionGenericReader {
    protected static final Logger LOG = LoggerFactory.getLogger(MultiVersionGenericAvroReader.class);

    public MultiVersionGenericJsonReader(boolean useProvidedSchemaAsReaderSchema, Schema readerSchema, SchemaInfo schemaInfo, List<Field> fields) {
        super(useProvidedSchemaAsReaderSchema, new GenericJsonReader(fields, schemaInfo), readerSchema);
    }

    @Override
    protected SchemaReader<GenericRecord> loadReader(BytesSchemaVersion schemaVersion) {
        SchemaInfo schemaInfo = this.getSchemaInfoByVersion(schemaVersion.get());
        if (schemaInfo != null) {
            LOG.info("Load schema reader for version({}), schema is : {}", (Object)SchemaUtils.getStringSchemaVersion(schemaVersion.get()), (Object)schemaInfo.getSchemaDefinition());
            Schema readerSchema = this.useProvidedSchemaAsReaderSchema ? this.readerSchema : SchemaUtil.parseAvroSchema(schemaInfo.getSchemaDefinition());
            return new GenericJsonReader(schemaVersion.get(), readerSchema.getFields().stream().map(f -> new Field(f.name(), f.pos())).collect(Collectors.toList()), schemaInfo);
        }
        LOG.warn("No schema found for version({}), use latest schema : {}", (Object)SchemaUtils.getStringSchemaVersion(schemaVersion.get()), (Object)this.readerSchema);
        return this.providerSchemaReader;
    }
}

