/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.util;

import com.navercorp.pinpoint.grpc.util.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;

public class FileSystemResource
implements Resource {
    private final File file;

    private FileSystemResource(File file) {
        Objects.requireNonNull(file, "file");
        this.file = file;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public File getFile() throws IOException {
        return this.file;
    }

    @Override
    public URL getURL() throws IOException {
        return this.file.toURI().toURL();
    }

    public static FileSystemResource createResource(String path) {
        File file = new File(path);
        return new FileSystemResource(file);
    }

    public static FileSystemResource createResource(String parent, String child) {
        File file = new File(parent, child);
        return new FileSystemResource(file);
    }
}

