/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.client;

import com.navercorp.pinpoint.common.util.Assert;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UnaryCallDeadlineInterceptor
implements ClientInterceptor {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final long timeoutMillis;

    public UnaryCallDeadlineInterceptor(long timeoutMillis) {
        Assert.isTrue((timeoutMillis > 0L ? 1 : 0) != 0, (String)"must be `timeoutMillis > 0`");
        this.timeoutMillis = timeoutMillis;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        if (MethodDescriptor.MethodType.UNARY == method.getType()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("interceptCall {}", (Object)method.getFullMethodName());
            }
            return next.newCall(method, callOptions.withDeadlineAfter(this.timeoutMillis, TimeUnit.MILLISECONDS));
        }
        return next.newCall(method, callOptions);
    }
}

